/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispRational;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.LispString;
import net.morilib.util.Inclimentor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LispBigInt
extends LispInteger {
    private BigInteger value;

    LispBigInt(BigInteger value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.value = value;
    }

    @Override
    public LispNumber add(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex(this.getRealDouble() + c.getRealDouble(), c.getImagDouble());
        }
        if (x instanceof LispInteger) {
            return LispInteger.valueOf(this.value.add(x.getBigInteger()));
        }
        if (x instanceof LispRational) {
            LispRational r = (LispRational)x;
            BigInteger nd = r.getDenominator();
            BigInteger nn = this.value.multiply(r.getDenominator()).add(r.getNumerator());
            return LispRational.newRational(nn, nd);
        }
        if (x instanceof LispDouble) {
            return new LispDouble(this.value.doubleValue() + ((LispDouble)x).doubleValue());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber div(LispNumber x) {
        if (x instanceof LispComplex) {
            double xr = ((LispComplex)x).getRealDouble();
            double xi = ((LispComplex)x).getImagDouble();
            double n = this.getRealDouble();
            if (xr == 0.0) {
                return LispComplex.newComplex(0.0, -n / xi);
            }
            return LispComplex.newComplex(n * xr / (xr * xr + xi * xi), -(n * xi) / (xr * xr + xi * xi));
        }
        if (x instanceof LispInteger) {
            return LispRational.newRational(this.value, x.getBigInteger());
        }
        if (x instanceof LispRational) {
            LispRational r = (LispRational)x;
            BigInteger nd = r.getNumerator();
            BigInteger nn = this.value.multiply(r.getDenominator());
            return LispRational.newRational(nn, nd);
        }
        if (x instanceof LispDouble) {
            return new LispDouble(this.value.doubleValue() / ((LispDouble)x).doubleValue());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber mul(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            if (c.getRealDouble() == 0.0) {
                return LispComplex.newComplex(0.0, this.getRealDouble() * c.getImagDouble());
            }
            return LispComplex.newComplex(this.getRealDouble() * c.getRealDouble(), this.getRealDouble() * c.getImagDouble());
        }
        if (x instanceof LispInteger) {
            return LispInteger.valueOf(this.value.multiply(x.getBigInteger()));
        }
        if (x instanceof LispRational) {
            LispRational r = (LispRational)x;
            BigInteger nd = r.getDenominator();
            BigInteger nn = this.value.multiply(r.getNumerator());
            return LispRational.newRational(nn, nd);
        }
        if (x instanceof LispDouble) {
            return new LispDouble(this.value.doubleValue() * ((LispDouble)x).doubleValue());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber sub(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex(this.getRealDouble() - c.getRealDouble(), -c.getImagDouble());
        }
        if (x instanceof LispInteger) {
            return LispInteger.valueOf(this.value.subtract(x.getBigInteger()));
        }
        if (x instanceof LispRational) {
            LispRational r = (LispRational)x;
            BigInteger nd = r.getDenominator();
            BigInteger nn = this.value.multiply(r.getDenominator()).subtract(r.getNumerator());
            return LispRational.newRational(nn, nd);
        }
        if (x instanceof LispDouble) {
            return new LispDouble(this.value.doubleValue() - ((LispDouble)x).doubleValue());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber uminus() {
        return new LispBigInt(this.value.negate());
    }

    @Override
    public boolean isEqualTo(LispNumber x) {
        if (x instanceof LispComplex) {
            return false;
        }
        if (x instanceof LispSmallInt) {
            return false;
        }
        if (x instanceof LispBigInt) {
            return this.value.equals(x.getBigInteger());
        }
        if (x instanceof LispRational) {
            return false;
        }
        if (x instanceof LispDouble) {
            return this.value.doubleValue() == ((LispDouble)x).doubleValue();
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public boolean isLessThan(LispReal x) {
        if (x instanceof LispInteger) {
            return this.value.compareTo(x.getBigInteger()) < 0;
        }
        if (x instanceof LispRational) {
            BigInteger n2;
            LispRational r = (LispRational)x;
            BigInteger n1 = this.value.multiply(r.getDenominator());
            return n1.compareTo(n2 = r.getNumerator()) < 0;
        }
        if (x instanceof LispDouble) {
            return this.value.doubleValue() < x.getRealDouble();
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public boolean isMoreThan(LispReal x) {
        if (x instanceof LispInteger) {
            return this.value.compareTo(x.getBigInteger()) > 0;
        }
        if (x instanceof LispRational) {
            BigInteger n2;
            LispRational r = (LispRational)x;
            BigInteger n1 = this.value.multiply(r.getDenominator());
            return n1.compareTo(n2 = r.getNumerator()) > 0;
        }
        if (x instanceof LispDouble) {
            return this.value.doubleValue() > x.getRealDouble();
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public int signum() {
        return this.value.signum();
    }

    @Override
    public LispNumber toInexact() {
        return new LispDouble(this.value.doubleValue());
    }

    public boolean equals(Object x) {
        if (x instanceof LispBigInt) {
            return this.value.equals(((LispBigInt)x).value);
        }
        return false;
    }

    public int hashCode() {
        int l = 17;
        l = 37 * l + this.value.hashCode();
        return l;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public String print() {
        return this.value.toString();
    }

    @Override
    public String getResult() {
        return this.value.toString();
    }

    @Override
    public LispString toLispString(int radix) {
        if (radix < 2 || radix > 36) {
            throw new IndexOutOfBoundsException("radix is out of range");
        }
        return new LispString(this.value.toString(radix));
    }

    @Override
    public boolean isOne() {
        return this.value.equals(BigInteger.ONE);
    }

    @Override
    public BigInteger getBigInteger() {
        return this.value;
    }

    @Override
    public int getInt() {
        return this.value.intValue();
    }

    @Override
    public long getLong() {
        return this.value.longValue();
    }

    @Override
    public BigDecimal getBigDecimal() {
        return new BigDecimal(this.value);
    }

    @Override
    public double getRealDouble() {
        return this.value.doubleValue();
    }

    @Override
    public boolean equalIncliment(Inclimentor<?> i) {
        if (i instanceof LispBigInt) {
            return this.value.equals(((LispBigInt)i).value);
        }
        return i.equalInt(this.value);
    }

    @Override
    public boolean equalInt(int i) {
        return this.value.equals(BigInteger.valueOf(i));
    }

    @Override
    public boolean equalInt(BigInteger i) {
        return this.value.equals(i);
    }

    @Override
    public Inclimentor<LispInteger> suc() {
        return LispInteger.valueOf(this.value.add(BigInteger.ONE));
    }

    @Override
    public Inclimentor<LispInteger> suc(int step) {
        return LispInteger.valueOf(this.value.add(BigInteger.valueOf(step)));
    }

    @Override
    public int toInt() {
        return this.value.intValue();
    }
}

