/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.List;
import net.morilib.lisp.CodeExecutor;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.IntLispUtils;
import net.morilib.lisp.IntStack;
import net.morilib.lisp.LispCompiler;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.SymbolName;
import net.morilib.lisp.Syntax;
import net.morilib.lisp.SyntaxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynJavaCall
extends Syntax {
    @Override
    void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento) {
        Datum method;
        Cons p1;
        if (body instanceof Cons) {
            p1 = (Cons)body;
            method = p1.getCar();
            if (!IntLispUtils.isSymbolName(method)) {
                throw mesg.getError("err.require.symbol", method);
            }
            if (!(p1.getCdr() instanceof Cons)) {
                throw mesg.getError("err.java-call.malform");
            }
        } else {
            throw mesg.getError("err.java-call.malform");
        }
        Cons p2 = (Cons)p1.getCdr();
        Datum klass = p2.getCar();
        Datum args = p2.getCdr();
        comp.compile(klass, env, build, callsym, false, symlist, exec, memento);
        comp.compileArgs(args, env, build, callsym, symlist, exec, memento);
        build.addJavaCall((SymbolName)((Object)method), klass);
    }

    @Override
    Datum replaceLocalVals(Datum body, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, boolean toplv) {
        Datum method;
        Cons p1;
        ConsListBuilder bld = new ConsListBuilder();
        if (body instanceof Cons) {
            p1 = (Cons)body;
            method = p1.getCar();
            if (!(method instanceof Symbol)) {
                throw mesg.getError("err.require.symbol", method);
            }
            if (!(p1.getCdr() instanceof Cons)) {
                throw mesg.getError("err.java-call.malform");
            }
        } else {
            throw mesg.getError("err.java-call.malform");
        }
        Cons p2 = (Cons)p1.getCdr();
        Datum klass = p2.getCar();
        Datum args = p2.getCdr();
        Datum rargs = SyntaxUtils.replaceLocalValsList(args, env, comp, ienv, mesg);
        bld.append(method);
        bld.append(comp.replaceLocalVals(klass, env, ienv, false));
        return bld.get(rargs);
    }
}

