/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.List;
import net.morilib.lisp.CodeExecutor;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.IntLispUtils;
import net.morilib.lisp.IntStack;
import net.morilib.lisp.JavaClass;
import net.morilib.lisp.JavaMethod;
import net.morilib.lisp.JavaProperty;
import net.morilib.lisp.LispCompiler;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.SymbolName;
import net.morilib.lisp.Syntax;
import net.morilib.lisp.Undef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynJavaImport
extends Syntax {
    private void introspect(JavaClass cls0, CompiledCode.Builder build, String name, LispMessage mesg) {
        try {
            Class<?> cls = cls0.getJavaClass();
            BeanInfo inf = Introspector.getBeanInfo(cls);
            FeatureDescriptor[] featureDescriptorArray = inf.getMethodDescriptors();
            int n = featureDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                MethodDescriptor m = featureDescriptorArray[n2];
                Method m0 = m.getMethod();
                String nm = String.valueOf(name) + "-" + m0.getName();
                build.addPush(new JavaMethod(nm, m0));
                build.addBind(Symbol.getSymbol(nm));
                ++n2;
            }
            featureDescriptorArray = inf.getPropertyDescriptors();
            n = featureDescriptorArray.length;
            n2 = 0;
            while (n2 < n) {
                FeatureDescriptor p = featureDescriptorArray[n2];
                String nm = String.valueOf(name) + "-" + p.getName();
                build.addPush(new JavaProperty(nm, (PropertyDescriptor)p));
                build.addBind(Symbol.getSymbol(nm));
                ++n2;
            }
        }
        catch (IntrospectionException e) {
            throw mesg.getError("err.java-import.classnotfound");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento) {
        if (!(body instanceof Cons)) throw mesg.getError("err.java-import.malform");
        Datum bcar = ((Cons)body).getCar();
        Datum bcdr = ((Cons)body).getCdr();
        if (!IntLispUtils.isSymbolName(bcar) || !(bcdr instanceof Cons)) throw mesg.getError("err.java-import.malform");
        Datum bcdar = ((Cons)bcdr).getCar();
        Datum bcddr = ((Cons)bcdr).getCdr();
        if (!IntLispUtils.isSymbolName(bcdar) || bcddr != Nil.NIL) {
            throw mesg.getError("err.java-import.malform");
        }
        try {
            JavaClass cls = new JavaClass(((SymbolName)((Object)bcdar)).getName());
            build.addPush(cls);
            build.addBind(bcar);
            this.introspect(cls, build, ((SymbolName)((Object)bcar)).getName(), mesg);
            build.addPush(Undef.UNDEF);
            return;
        }
        catch (ClassNotFoundException e) {
            throw mesg.getError("err.java-import.classnotfound", bcdar);
        }
    }

    @Override
    Datum replaceLocalVals(Datum body, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, boolean toplv) {
        if (body instanceof Cons) {
            Datum bcar = ((Cons)body).getCar();
            Datum bcdr = ((Cons)body).getCdr();
            if (bcar instanceof Symbol && bcdr instanceof Symbol) {
                return body;
            }
            throw mesg.getError("err.java-import.malform");
        }
        throw mesg.getError("err.java-import.malform");
    }
}

