/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.ArrayList;
import java.util.List;
import net.morilib.lisp.CodeExecutor;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.IntStack;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispCompiler;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Syntax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynOr
extends Syntax {
    @Override
    void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento) {
        Datum p = body;
        int last = build.allocLabel();
        build.addPush(LispBoolean.FALSE);
        while (p instanceof Cons) {
            Cons c = (Cons)p;
            build.addPop();
            comp.compile(c.getCar(), env, build, callsym, istail && c.getCdr() == Nil.NIL, symlist, exec, memento);
            build.addJmpIf(last);
            p = c.getCdr();
        }
        if (p != Nil.NIL) {
            throw mesg.getError("err.list");
        }
        build.setCurrentAddressToLabel(last);
    }

    @Override
    Datum replaceLocalVals(Datum body, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, boolean toplv) {
        List<Datum> lst = LispUtils.consToList(body, mesg);
        ArrayList<Datum> res = new ArrayList<Datum>();
        int i = 0;
        while (i < lst.size()) {
            res.add(comp.replaceLocalVals(lst.get(i), env, ienv, false));
            ++i;
        }
        return LispUtils.listToCons(res);
    }
}

