/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.subr;

import java.math.BigInteger;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.LispException;
import net.morilib.lisp.LispSmallInt;

class SubrUtils {
    SubrUtils() {
    }

    static BigInteger ceil(BigInteger n, BigInteger d) {
        BigInteger v = n;
        if (v.compareTo(BigInteger.ZERO) > 0) {
            v = v.add(d);
        }
        return v.divide(d);
    }

    static BigInteger floor(BigInteger n, BigInteger d) {
        BigInteger v = n;
        if (v.compareTo(BigInteger.ZERO) < 0) {
            v = v.subtract(d);
        }
        return v.divide(d);
    }

    static Integer toIntExact(BigInteger i) {
        int r = i.intValue();
        if (i.equals(BigInteger.valueOf(r))) {
            return new Integer(r);
        }
        return null;
    }

    static int getSmallIntegerExact(Datum d) {
        if (d instanceof LispSmallInt) {
            LispSmallInt li = (LispSmallInt)d;
            return li.getExactSmallInt();
        }
        throw new LispException("small integer required");
    }

    static char getCharacter(Datum d) {
        if (d instanceof LispCharacter) {
            return ((LispCharacter)d).getCharacter();
        }
        throw new LispException("character required");
    }
}

