/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.util.LispHandler;
import net.morilib.util.Utils;

public final class InitLispLoader {
    private static final String INIT_XML = "/net/morilib/lisp/init/initlisp.xml";
    private static Properties initProp = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void load(Scheme lsp) {
        if (initProp == null) {
            Class<InitLispLoader> clazz = InitLispLoader.class;
            // MONITORENTER : net.morilib.lisp.InitLispLoader.class
            InputStream ins = null;
            try {
                try {
                    initProp = new Properties();
                    ins = InitLispLoader.class.getResourceAsStream(INIT_XML);
                    initProp.loadFromXML(ins);
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot load propfile", e);
                }
            }
            catch (Throwable throwable) {
                Utils.close(ins);
                throw throwable;
            }
            Utils.close(ins);
            // MONITOREXIT : clazz
        }
        for (Object s : initProp.values()) {
            InitLispLoader.load1(lsp, (String)s);
        }
    }

    public static void loadNullEnv(Scheme lsp, int ver) {
    }

    public static void loadRnRSEnv(Scheme lsp, int ver) {
        switch (ver) {
            case 5: {
                InitLispLoader.load1(lsp, "/net/morilib/lisp/init/r5rs.scm");
            }
        }
    }

    private static void load1(Scheme lsp, String fn) {
        InputStream ins = null;
        try {
            try {
                LispHandler.setLoggable2(false);
                ins = InitLispLoader.class.getResourceAsStream(fn);
                InputStreamReader rd = new InputStreamReader(ins);
                lsp.readFile(rd);
                LispHandler.setLoggable2(true);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot load initfile", e);
            }
        }
        catch (Throwable throwable) {
            Utils.close(ins);
            throw throwable;
        }
        Utils.close(ins);
    }
}

