/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.lang.reflect.Method;
import java.util.List;
import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.IntLispUtils;
import net.morilib.lisp.IntPrmNotFoundException;
import net.morilib.lisp.JavaInstance;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;

class JavaMethod
extends Subr {
    private Method mthdesc;

    JavaMethod(String name, Method pd) {
        this.symbolName = name;
        this.mthdesc = pd;
    }

    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        if (body instanceof Cons) {
            Cons c0 = (Cons)body;
            List<Datum> lst = LispUtils.consToList(c0.getCdr(), mesg);
            if (!(c0.getCar() instanceof JavaInstance)) {
                throw mesg.getError("err.require.java-bean", c0.getCar());
            }
            try {
                JavaInstance bn = (JavaInstance)c0.getCar();
                Object jo = IntLispUtils.invokeMethod(this.mthdesc, bn.getJavaInstance(), lst);
                return LispUtils.toDatum(jo);
            }
            catch (IntPrmNotFoundException e) {
                throw mesg.getError("err.java.method.notfound");
            }
        }
        throw mesg.getError("err.argument");
    }
}

