;;;
;;; Copyright 2009 Yuichiro Moriguchi
;;; 
;;; Licensed under the Apache License, Version 2.0 (the "License");
;;; you may not use this file except in compliance with the License.
;;; You may obtain a copy of the License at
;;; 
;;;     http://www.apache.org/licenses/LICENSE-2.0
;;; 
;;; Unless required by applicable law or agreed to in writing, software
;;; distributed under the License is distributed on an "AS IS" BASIS,
;;; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
;;; See the License for the specific language governing permissions and
;;; limitations under the License.

(define *use-path* '(net.morilib.lisp.lib))

(define (add-load-path pth . afterp)
  (if (not (string? pth))
    (error (get-default-message 'err.require.string)))
  (if (equal? afterp '(#t))
      (set! *load-path* (append *load-path* (list pth)))
      (set! *load-path* (cons pth *load-path*))))

(define-syntax define-java-subr
  (syntax-rules ()
    ((_ v s) (define v ($get-java-subr (quote v) (quote s))))))

;;
(define (debug-print x)
  (format #t "#?=~A~%" x)
  x)
(define-sharp-quote "#\\?=" 'debug-print)

;; SRFI-17
(set! (setter car) set-car!)
(set! (setter cdr) set-cdr!)
(set! (setter caar) (lambda (x v) (set-car! (car x) v)))
(set! (setter cadr) (lambda (x v) (set-car! (cdr x) v)))
(set! (setter cdar) (lambda (x v) (set-cdr! (car x) v)))
(set! (setter cddr) (lambda (x v) (set-cdr! (cdr x) v)))
(set! (setter caaar) (lambda (x v) (set-car! (caar x) v)))
(set! (setter caadr) (lambda (x v) (set-car! (cadr x) v)))
(set! (setter cadar) (lambda (x v) (set-car! (cdar x) v)))
(set! (setter caddr) (lambda (x v) (set-car! (cddr x) v)))
(set! (setter cdaar) (lambda (x v) (set-cdr! (caar x) v)))
(set! (setter cdadr) (lambda (x v) (set-cdr! (cadr x) v)))
(set! (setter cddar) (lambda (x v) (set-cdr! (cdar x) v)))
(set! (setter cdddr) (lambda (x v) (set-cdr! (cddr x) v)))
(set! (setter caaaar) (lambda (x v) (set-car! (caaar x) v)))
(set! (setter caaadr) (lambda (x v) (set-car! (caadr x) v)))
(set! (setter caadar) (lambda (x v) (set-car! (cadar x) v)))
(set! (setter caaddr) (lambda (x v) (set-car! (caddr x) v)))
(set! (setter cadaar) (lambda (x v) (set-car! (cdaar x) v)))
(set! (setter cadadr) (lambda (x v) (set-car! (cdadr x) v)))
(set! (setter caddar) (lambda (x v) (set-car! (cddar x) v)))
(set! (setter cadddr) (lambda (x v) (set-car! (cdddr x) v)))
(set! (setter cdaaar) (lambda (x v) (set-cdr! (caaar x) v)))
(set! (setter cdaadr) (lambda (x v) (set-cdr! (caadr x) v)))
(set! (setter cdadar) (lambda (x v) (set-cdr! (cadar x) v)))
(set! (setter cdaddr) (lambda (x v) (set-cdr! (caddr x) v)))
(set! (setter cddaar) (lambda (x v) (set-cdr! (cdaar x) v)))
(set! (setter cddadr) (lambda (x v) (set-cdr! (cdadr x) v)))
(set! (setter cdddar) (lambda (x v) (set-cdr! (cddar x) v)))
(set! (setter cddddr) (lambda (x v) (set-cdr! (cdddr x) v)))
(set! (setter vector-ref) vector-set!)
(set! (setter string-ref) string-set!)
(set! (setter slot-ref) slot-set!)

(define (getter-with-setter get set)
  (let ((proc (lambda args (apply get args))))
    (set! (setter proc) set)
    proc))
