/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.sss.servlet.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.sss.Loggable;
import net.morilib.lisp.sss.servlet.http.GetAttribute;
import net.morilib.lisp.sss.servlet.http.LispHttpRequest;
import net.morilib.lisp.sss.servlet.http.LispHttpResponse;
import net.morilib.lisp.sss.servlet.http.LispHttpSession;
import net.morilib.lisp.sss.servlet.http.SchlushServletException;
import net.morilib.lisp.sss.servlet.http.SetAttributeS;

public class SchlushHttpServlet
extends HttpServlet {
    private static final long serialVersionUID = -6114578505278185400L;
    private static final String INIT_P = "scheme-root";
    private static final String SCHEME_ENC = "scheme-encoding";
    private static final String DO_DELETE = "do-delete";
    private static final String DO_GET = "do-get";
    private static final String DO_HEAD = "do-head";
    private static final String DO_OPTIONS = "do-options";
    private static final String DO_POST = "do-post";
    private static final String DO_PUT = "do-put";
    private static final String DO_TRACE = "do-trace";
    private Map<String, Scheme> schemes = new HashMap<String, Scheme>();

    private void initScheme(Scheme s) {
        s.set("*servlet*", (Object)new LispHttpServlet(this));
        s.set("get-parameter", (Object)new LispHttpRequest.GetParameter());
        s.set("get-parameter-integer", (Object)new LispHttpRequest.GetParameterInteger());
        s.set("set-character-encoding", (Object)new LispHttpRequest.SetCharacterEncoding());
        s.set("session-valid?", (Object)new LispHttpRequest.IsSessionValid());
        s.set("get-session", (Object)new LispHttpRequest.GetSession());
        s.set("set-content-type", (Object)new LispHttpResponse.SetContentType());
        s.set("get-output-port", (Object)new LispHttpResponse.GetOutputPort());
        s.set("invalidate", (Object)new LispHttpSession.Invalidate());
        s.set("get-attribute", (Object)new GetAttribute());
        s.set("set-attribute!", (Object)new SetAttributeS());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Scheme getScheme(String s) {
        String s2 = s.replaceFirst("^/[^/]+", "");
        Scheme res = this.schemes.get(s2);
        if (res == null) {
            SchlushHttpServlet schlushHttpServlet = this;
            synchronized (schlushHttpServlet) {
                String enc = this.getInitParameter(SCHEME_ENC);
                String sh = this.getInitParameter(INIT_P);
                InputStream ins = null;
                if (enc == null) {
                    enc = "UTF-8";
                }
                sh = sh.replace('.', '/');
                sh = "/" + sh.replaceFirst("^/", "");
                sh = String.valueOf(sh.replaceFirst("/$", "")) + "/";
                try {
                    try {
                        ins = SchlushHttpServlet.class.getResourceAsStream(String.valueOf(sh) + s2);
                        if (ins == null) {
                            throw new SchlushServletException("not found:" + sh + s2);
                        }
                        res = Scheme.newInstance();
                        res.readFile((Reader)new InputStreamReader(ins, enc));
                        this.initScheme(res);
                        this.schemes.put(s2, res);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new SchlushServletException(e);
                    }
                    catch (IOException e) {
                        throw new SchlushServletException(e);
                    }
                }
                finally {
                    if (ins != null) {
                        try {
                            ins.close();
                        }
                        catch (IOException e) {
                            throw new SchlushServletException(e);
                        }
                    }
                }
            }
        }
        return res;
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Scheme s = this.getScheme(req.getRequestURI());
        s.call(DO_DELETE, new Object[]{new LispHttpRequest(req), new LispHttpResponse(resp)});
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Scheme s = this.getScheme(req.getRequestURI());
        s.call(DO_GET, new Object[]{new LispHttpRequest(req), new LispHttpResponse(resp)});
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Scheme s = this.getScheme(req.getRequestURI());
        s.call(DO_HEAD, new Object[]{new LispHttpRequest(req), new LispHttpResponse(resp)});
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Scheme s = this.getScheme(req.getRequestURI());
        s.call(DO_OPTIONS, new Object[]{new LispHttpRequest(req), new LispHttpResponse(resp)});
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Scheme s = this.getScheme(req.getRequestURI());
        s.call(DO_POST, new Object[]{new LispHttpRequest(req), new LispHttpResponse(resp)});
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Scheme s = this.getScheme(req.getRequestURI());
        s.call(DO_PUT, new Object[]{new LispHttpRequest(req), new LispHttpResponse(resp)});
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Scheme s = this.getScheme(req.getRequestURI());
        s.call(DO_TRACE, new Object[]{new LispHttpRequest(req), new LispHttpResponse(resp)});
    }

    private static class LispHttpServlet
    extends Datum
    implements Loggable {
        private HttpServlet servlet;

        private LispHttpServlet(HttpServlet servlet) {
            this.servlet = servlet;
        }

        @Override
        public void log(String str) {
            this.servlet.log(str);
        }

        public void toDisplayString(StringBuilder buf) {
            buf.append("#<http-servlet>");
        }
    }
}

