/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang.number;

import java.math.BigInteger;
import net.morilib.lang.algebra.AlgebricInteger;
import net.morilib.lang.number.AbstractNumerical;
import net.morilib.lang.number.BigInt;
import net.morilib.lang.number.Integer2Ring;
import net.morilib.lang.number.NumericalRing;
import net.morilib.lang.number.Rational;
import net.morilib.lang.number.SmallInt;

public abstract class Integer2
extends AbstractNumerical<Integer2>
implements AlgebricInteger<Integer2> {
    private static final BigInteger _I_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger _I_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    public static final Integer2 ZERO = Integer2.valueOf(0);
    public static final Integer2 ONE = Integer2.valueOf(1);

    Integer2() {
    }

    public static Integer2 valueOf(BigInteger val) {
        if (val.compareTo(_I_MAX) > 0 || val.compareTo(_I_MIN) < 0) {
            return new BigInt(val);
        }
        return new SmallInt(val.intValue());
    }

    public static Integer2 valueOf(int val) {
        return new SmallInt(val);
    }

    public static Integer2 valueOf(long val) {
        if (val > Integer.MAX_VALUE || val < Integer.MIN_VALUE) {
            return new BigInt(BigInteger.valueOf(val));
        }
        return new SmallInt((int)val);
    }

    public byte toByte() {
        return (byte)this.toInt();
    }

    public short toShort() {
        return (short)this.toInt();
    }

    public abstract int toInt();

    public abstract long toLong();

    public abstract BigInteger toBigInteger();

    @Override
    public int intFloor() {
        return this.toInt();
    }

    @Override
    public long longFloor() {
        return this.toLong();
    }

    @Override
    public int intCeil() {
        return this.toInt();
    }

    @Override
    public long longCeil() {
        return this.toLong();
    }

    @Override
    public final boolean isInteger() {
        return true;
    }

    @Override
    public NumericalRing<Integer2> getUniverse() {
        return Integer2Ring.getInstance();
    }

    @Override
    public Integer2 getInteger2Floor() {
        return this;
    }

    @Override
    public Integer2 getInteger2Ceil() {
        return this;
    }

    @Override
    public Rational getRational() {
        return Rational.valueOf(this, ONE);
    }
}

