/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang.number;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.morilib.lang.number.Integer2;
import net.morilib.lang.number.Rational;

public final class Numbers {
    private Numbers() {
    }

    private static Integer2 toInteger2(Number n) {
        Integer2 d;
        if (n instanceof Integer || n instanceof Short || n instanceof Byte || n instanceof Long) {
            d = Integer2.valueOf(n.longValue());
        } else if (n instanceof Double || n instanceof Float) {
            Rational r = Rational.valueOf(n.doubleValue());
            if (!r.isInteger()) {
                return null;
            }
            d = r.getIntegerPart();
        } else if (n instanceof BigDecimal) {
            Rational r = Rational.valueOf((BigDecimal)n);
            if (!r.isInteger()) {
                return null;
            }
            d = r.getIntegerPart();
        } else if (n instanceof BigInteger) {
            d = Integer2.valueOf((BigInteger)n);
        } else {
            return null;
        }
        return d;
    }

    public static boolean equalTo(Number n, long i) {
        Integer2 d = Numbers.toInteger2(n);
        if (d != null) {
            return d.inLongRange() && i == d.toLong();
        }
        return false;
    }

    public static boolean between(Number n, long f, long t) {
        Integer2 d = Numbers.toInteger2(n);
        if (d != null && d.inLongRange()) {
            return d.toLong() >= f && d.toLong() <= t;
        }
        return false;
    }

    public static int compare(double a, double b) {
        return a < b ? -1 : (a > b ? 1 : 0);
    }
}

