/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang.number.complex;

import net.morilib.lang.number.complex.ComplexDouble;
import net.morilib.lang.number.complex.RectanglarComplexDouble;

public class RectanglarComplexDoubleRegister {
    public double real;
    public double imag;

    public RectanglarComplexDoubleRegister(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public RectanglarComplexDoubleRegister(ComplexDouble z) {
        this.real = z.realPart();
        this.imag = z.imagPart();
    }

    public boolean isReal() {
        return this.imag == 0.0;
    }

    public boolean isInteger() {
        return this.isReal() && Math.IEEEremainder(this.real, 1.0) == 0.0;
    }

    public boolean isUnit() {
        return this.real == 1.0 && this.imag == 0.0;
    }

    public boolean isZero() {
        return this.real == 0.0 && this.imag == 0.0;
    }

    public RectanglarComplexDoubleRegister negate() {
        this.real = -this.real;
        this.imag = -this.imag;
        return this;
    }

    public RectanglarComplexDoubleRegister subtract(ComplexDouble x) {
        this.real -= x.realPart();
        this.imag -= x.imagPart();
        return this;
    }

    public RectanglarComplexDoubleRegister add(ComplexDouble x) {
        this.real += x.realPart();
        this.imag += x.imagPart();
        return this;
    }

    public RectanglarComplexDoubleRegister multiply(int n) {
        this.real *= (double)n;
        this.imag *= (double)n;
        return this;
    }

    public RectanglarComplexDoubleRegister multiply(ComplexDouble x) {
        double r = this.real;
        double i = this.imag;
        this.real = r * x.realPart() - i * x.imagPart();
        this.imag = r * x.imagPart() + i * x.realPart();
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RectanglarComplexDoubleRegister power(int n) {
        if (this.isZero()) {
            if (n < 1) throw new ArithmeticException(this.toString());
            this.imag = 0.0;
            this.real = 0.0;
            return this;
        } else {
            if (this.isUnit()) {
                return this;
            }
            if (n == 0) {
                this.real = 1.0;
                this.imag = 0.0;
                return this;
            } else {
                if (n == 1) {
                    return this;
                }
                if (n == -1) {
                    return this.invert();
                }
                if (n > 1) {
                    ComplexDouble res = RectanglarComplexDouble.valueOf(this.real, this.imag);
                    int i = 1;
                    while (i < n) {
                        this.multiply(res);
                        ++i;
                    }
                    return this;
                } else {
                    ComplexDouble res = RectanglarComplexDouble.valueOf(this.real, this.imag);
                    this.real = 1.0;
                    this.imag = 0.0;
                    int i = 0;
                    while (i < n) {
                        this.divide(res);
                        ++i;
                    }
                }
            }
        }
        return this;
    }

    public RectanglarComplexDoubleRegister invert() {
        double c = this.real;
        double d = this.imag;
        double n = c * c + d * d;
        this.real = c / n;
        this.imag = -d / n;
        return this;
    }

    public RectanglarComplexDoubleRegister divide(ComplexDouble x) {
        double a = this.real;
        double b = this.imag;
        double c = x.realPart();
        double d = x.imagPart();
        double n = c * c + d * d;
        this.real = (a * c + b * d) / n;
        this.imag = (b * c - a * d) / n;
        return this;
    }

    public RectanglarComplexDoubleRegister multiply(double x) {
        if (x == 0.0) {
            this.imag = 0.0;
            this.real = 0.0;
        } else {
            this.real *= x;
            this.imag *= x;
        }
        return this;
    }

    public RectanglarComplexDoubleRegister divide(double x) {
        if (x == 0.0) {
            this.imag = Double.POSITIVE_INFINITY;
            this.real = Double.POSITIVE_INFINITY;
        } else {
            this.real /= x;
            this.imag /= x;
        }
        return this;
    }

    public RectanglarComplexDoubleRegister add(double x) {
        this.real += x;
        return this;
    }

    public RectanglarComplexDoubleRegister subtract(double x) {
        this.real -= x;
        return this;
    }

    public ComplexDouble toComplex() {
        return RectanglarComplexDouble.valueOf(this.real, this.imag);
    }
}

