/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.Map;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.r6rs.LibraryID;
import net.morilib.lisp.r6rs.LibraryIDException;
import net.morilib.lisp.r6rs.SymbolEnv;
import net.morilib.lisp.subr.BinaryArgs;

public class EnvironmentObject
extends Datum {
    private Environment environment;
    private boolean inherit = false;

    private EnvironmentObject(Environment environment, boolean inherit) {
        if (environment == null) {
            throw new NullPointerException();
        }
        this.environment = environment;
        this.inherit = inherit;
    }

    static EnvironmentObject newNullEnv(int ver) {
        return new EnvironmentObject(Scheme.newNullEnv(ver), false);
    }

    static EnvironmentObject newRnRSEnv(int ver) {
        return new EnvironmentObject(Scheme.newRnRSEnv(ver), false);
    }

    static EnvironmentObject newInteractionEnv(Environment e) {
        return new EnvironmentObject(e, true);
    }

    Environment getEnvironment() {
        return this.environment;
    }

    boolean isInherit() {
        return this.inherit;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<environment>");
    }

    /* synthetic */ EnvironmentObject(Environment environment, boolean bl, EnvironmentObject environmentObject) {
        this(environment, bl);
    }

    public static class BindEnvironment
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            Map<Datum, Datum> maps = LispUtils.assocToMap(c1a);
            if (maps == null) {
                throw mesg.getError("err.require.assoc", c1a);
            }
            if (!(c2a instanceof EnvironmentObject)) {
                throw mesg.getError("err.environment", c2a);
            }
            Environment eo = ((EnvironmentObject)c2a).getEnvironment();
            for (Map.Entry<Datum, Datum> e : maps.entrySet()) {
                if (!(e.getKey() instanceof Symbol)) {
                    throw mesg.getError("err.require.symbol", e.getKey());
                }
                Symbol s = (Symbol)e.getKey();
                eo.bindDatumReadOnly(s, e.getValue());
            }
            return c2a;
        }
    }

    public static class R6RSEnvironment
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            Map<Symbol, SymbolEnv> mp;
            Environment env2 = new Environment();
            try {
                mp = LibraryID.compileImport(body);
            }
            catch (LibraryIDException e) {
                throw e.toLispException(mesg);
            }
            for (Map.Entry<Symbol, SymbolEnv> e : mp.entrySet()) {
                Environment env3 = e.getValue().getEnvironment();
                env2.bindDatumReadOnly(e.getValue().getSymbol(), env3.getDatum(e.getKey()));
            }
            return new EnvironmentObject(env2, false, null);
        }
    }
}

