/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.logging.Logger;
import net.morilib.lisp.Atom;
import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.IntPrmNotFoundException;
import net.morilib.lisp.JavaException;
import net.morilib.lisp.JavaInstance;
import net.morilib.lisp.JavaNull;
import net.morilib.lisp.JavaTargetException;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.SymbolName;
import net.morilib.lisp.SymbolScope;
import net.morilib.lisp.Syntax;
import net.morilib.lisp.Undef;
import net.morilib.lisp.util.ReflContainer;

final class IntLispUtils {
    private static final Object NOTFOUND = new Object();

    private IntLispUtils() {
    }

    static Cons nconc(Cons a, Cons b) {
        Cons p = a;
        while (p.getCdr() instanceof Cons) {
            p = (Cons)p.getCdr();
        }
        p.setCdr(b);
        return a;
    }

    static Datum car(Datum d, LispMessage mesg) {
        if (d instanceof Cons) {
            return ((Cons)d).getCar();
        }
        throw mesg.getError("err.require.pair");
    }

    static Datum cdr(Datum d, LispMessage mesg) {
        if (d instanceof Cons) {
            return ((Cons)d).getCdr();
        }
        throw mesg.getError("err.require.pair");
    }

    static Datum caar(Datum d, LispMessage mesg) {
        Datum c0;
        if (d instanceof Cons && (c0 = ((Cons)d).getCar()) instanceof Cons) {
            return ((Cons)c0).getCar();
        }
        throw mesg.getError("err.require.pair");
    }

    static Datum cdar(Datum d, LispMessage mesg) {
        Datum c0;
        if (d instanceof Cons && (c0 = ((Cons)d).getCar()) instanceof Cons) {
            return ((Cons)c0).getCdr();
        }
        throw mesg.getError("err.require.pair");
    }

    static Datum cadr(Datum d, LispMessage mesg) {
        Datum c0;
        if (d instanceof Cons && (c0 = ((Cons)d).getCdr()) instanceof Cons) {
            return ((Cons)c0).getCar();
        }
        throw mesg.getError("err.require.pair");
    }

    static Datum cddr(Datum d, LispMessage mesg) {
        Datum c0;
        if (d instanceof Cons && (c0 = ((Cons)d).getCdr()) instanceof Cons) {
            return ((Cons)c0).getCdr();
        }
        throw mesg.getError("err.require.pair");
    }

    static boolean isAssignableInt(Class<?> rtp) {
        return Integer.TYPE.isAssignableFrom(rtp) || Integer.class.isAssignableFrom(rtp);
    }

    static boolean isAssignableLong(Class<?> rtp) {
        return Long.TYPE.isAssignableFrom(rtp) || Long.class.isAssignableFrom(rtp);
    }

    static boolean isAssignableFloat(Class<?> rtp) {
        return Float.TYPE.isAssignableFrom(rtp) || Float.class.isAssignableFrom(rtp);
    }

    static boolean isAssignableDouble(Class<?> rtp) {
        return Double.TYPE.isAssignableFrom(rtp) || Double.class.isAssignableFrom(rtp);
    }

    static boolean isAssignableBigInteger(Class<?> rtp) {
        return BigInteger.class.isAssignableFrom(rtp);
    }

    static boolean isAssignableBigDecimal(Class<?> rtp) {
        return BigDecimal.class.isAssignableFrom(rtp);
    }

    static BigInteger toIntegerExact(double number) {
        block3: {
            try {
                if (!Double.isInfinite(number) && !Double.isNaN(number)) break block3;
                return null;
            }
            catch (ArithmeticException e) {
                return null;
            }
        }
        BigDecimal dec = new BigDecimal(number);
        return dec.toBigIntegerExact();
    }

    static Integer toIntExact(BigInteger i) {
        int r = i.intValue();
        if (i.equals(BigInteger.valueOf(r))) {
            return new Integer(r);
        }
        return null;
    }

    static void bindLocal(Datum prms, Datum bcdr, Environment env, LispMessage mesg) {
        block10: {
            while (true) {
                if (prms == Nil.NIL) {
                    if (bcdr != Nil.NIL) {
                        throw mesg.getError("err.parameter.insufficient");
                    }
                    break block10;
                }
                if (prms instanceof Atom) {
                    if (!(prms instanceof Symbol)) {
                        throw mesg.getError("err.symbol", prms);
                    }
                    env.bindDatum(prms, bcdr);
                    break block10;
                }
                if (!(bcdr instanceof Cons)) {
                    throw mesg.getError("err.parameter.insufficient");
                }
                if (!(prms instanceof Cons)) break;
                Datum a1 = ((Cons)prms).getCar();
                Datum a2 = ((Cons)bcdr).getCar();
                if (a1 instanceof Symbol) {
                    env.bindDatum(a1, a2);
                } else if (a1 instanceof SymbolScope) {
                    SymbolScope ssp = (SymbolScope)a1;
                    env.bindDatum(ssp.getSymbol(), a2);
                } else {
                    throw mesg.getError("err.symbol", a1);
                }
                prms = ((Cons)prms).getCdr();
                bcdr = ((Cons)bcdr).getCdr();
            }
            throw mesg.getError("err.type.insufficient");
        }
    }

    static Datum findListEqv(Datum k, Datum lst, LispMessage mesg) {
        Datum d = lst;
        while (d != Nil.NIL) {
            if (lst instanceof Cons) {
                Cons c1 = (Cons)d;
                if (c1.getCar() instanceof Symbol) {
                    Symbol s = (Symbol)c1.getCar();
                    Symbol r = s.getEnclosedSymbol();
                    if (r == null && k == s) {
                        return k;
                    }
                    if (k == r) {
                        return k;
                    }
                } else if (k.isEqv(c1.getCar())) {
                    return k;
                }
                d = c1.getCdr();
                continue;
            }
            throw mesg.getError("err.list");
        }
        return LispBoolean.FALSE;
    }

    private static Class<?> getCompornentType(Class<?> cl) {
        if (cl.isArray()) {
            return cl.getComponentType();
        }
        if (cl.isAssignableFrom(List.class)) {
            return null;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    static boolean isSameClass(Class<?> cl, Datum ld) {
        block14: {
            if (cl.equals(Object.class)) {
                return true;
            }
            if (ld instanceof LispString) {
                return cl.isAssignableFrom(String.class);
            }
            if (ld instanceof LispBoolean) {
                return cl.isAssignableFrom(Boolean.TYPE) != false || cl.isAssignableFrom(Boolean.class) != false;
            }
            if (ld instanceof LispCharacter) {
                return cl.isAssignableFrom(Character.TYPE) != false || cl.isAssignableFrom(Character.class) != false;
            }
            if (ld instanceof LispInteger) {
                return IntLispUtils.isAssignableInt(cl) != false || IntLispUtils.isAssignableLong(cl) != false || IntLispUtils.isAssignableFloat(cl) != false || IntLispUtils.isAssignableDouble(cl) != false || IntLispUtils.isAssignableBigInteger(cl) != false || IntLispUtils.isAssignableBigDecimal(cl) != false;
            }
            if (ld instanceof LispReal) {
                return IntLispUtils.isAssignableInt(cl) != false || IntLispUtils.isAssignableLong(cl) != false || IntLispUtils.isAssignableFloat(cl) != false || IntLispUtils.isAssignableDouble(cl) != false || IntLispUtils.isAssignableBigInteger(cl) != false || IntLispUtils.isAssignableBigDecimal(cl) != false;
            }
            if (!(ld instanceof Cons)) break block14;
            p = ld;
            cc = IntLispUtils.getCompornentType(cl);
            if (cc != null) ** GOTO lbl25
            return false;
lbl-1000:
            // 1 sources

            {
                if (p instanceof Cons) {
                    c = (Cons)p;
                    if (!IntLispUtils.isSameClass(cc, c.getCar())) {
                        return false;
                    }
                    p = c.getCdr();
                    continue;
                }
                return false;
lbl25:
                // 2 sources

                ** while (p != Nil.NIL)
            }
lbl26:
            // 1 sources

            return true;
        }
        if (ld instanceof LispVector) {
            cc = IntLispUtils.getCompornentType(cl);
            if (cc == null) {
                return false;
            }
            for (Datum o : ((LispVector)ld).getList()) {
                if (IntLispUtils.isSameClass(cc, o)) continue;
                return false;
            }
            return true;
        }
        if (ld instanceof JavaInstance) {
            return cl.isAssignableFrom(((JavaInstance)ld).getJavaInstance().getClass());
        }
        if (ld == JavaNull.JAVA_NULL) {
            return true;
        }
        return ld == Nil.NIL;
    }

    static boolean isSameClasses(Class<?>[] cl, List<Datum> ld, boolean varargs) {
        if (!varargs && cl.length != ld.size()) {
            return false;
        }
        if (cl.length - 1 > ld.size()) {
            return false;
        }
        int i = 0;
        while (i < ld.size()) {
            if (varargs && i >= cl.length - 1) {
                Class<?> lcl = cl[cl.length - 1];
                if (!lcl.isArray()) {
                    return false;
                }
                if (!IntLispUtils.isSameClass(lcl.getComponentType(), ld.get(i))) {
                    return false;
                }
            } else if (!IntLispUtils.isSameClass(cl[i], ld.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static Object toJavaInstance(Class<?> cl, Datum d) {
        if (cl.equals(Object.class)) {
            return d;
        }
        if (d instanceof LispString) {
            return d.getString();
        }
        if (d instanceof LispBoolean) {
            return d.isTrue();
        }
        if (d instanceof LispCharacter) {
            return new Character(d.getCharacter());
        }
        if (d instanceof LispInteger) {
            if (IntLispUtils.isAssignableInt(cl)) {
                return new Integer(d.getInt());
            }
            if (IntLispUtils.isAssignableLong(cl)) {
                return new Long(d.getLong());
            }
            if (IntLispUtils.isAssignableFloat(cl)) {
                return new Float(d.getRealDouble());
            }
            if (IntLispUtils.isAssignableDouble(cl)) {
                return new Double(d.getRealDouble());
            }
            if (IntLispUtils.isAssignableBigInteger(cl)) {
                return d.getBigInteger();
            }
            if (IntLispUtils.isAssignableBigDecimal(cl)) {
                return d.getBigDecimal();
            }
            throw new ClassCastException(cl.getName());
        }
        if (d instanceof LispReal) {
            if (IntLispUtils.isAssignableInt(cl)) {
                return new Integer(d.getInt());
            }
            if (IntLispUtils.isAssignableLong(cl)) {
                return new Long(d.getLong());
            }
            if (IntLispUtils.isAssignableFloat(cl)) {
                return new Float(d.getRealDouble());
            }
            if (IntLispUtils.isAssignableDouble(cl)) {
                return new Double(d.getRealDouble());
            }
            if (IntLispUtils.isAssignableBigInteger(cl)) {
                return d.getBigInteger();
            }
            if (IntLispUtils.isAssignableBigDecimal(cl)) {
                return d.getBigDecimal();
            }
            throw new ClassCastException(cl.getName());
        }
        if (d instanceof Cons) {
            Datum p = d;
            Class<?> cc = IntLispUtils.getCompornentType(cl);
            int len = LispUtils.consLength(d);
            if (cc == null) {
                throw new ClassCastException(cl.getName());
            }
            ReflContainer cnt = new ReflContainer(cl, len);
            int i = 0;
            while (p != Nil.NIL) {
                if (!(p instanceof Cons)) {
                    throw new ClassCastException(cl.getName());
                }
                Cons c = (Cons)p;
                cnt.set(i, IntLispUtils.toJavaInstance(cc, c.getCar()));
                p = c.getCdr();
                ++i;
            }
            return cnt.toObject();
        }
        if (d instanceof LispVector) {
            Class<?> cc = IntLispUtils.getCompornentType(cl);
            int len = LispUtils.consLength(d);
            if (cc == null) {
                throw new ClassCastException(cl.getName());
            }
            ReflContainer cnt = new ReflContainer(cl, len);
            int i = 0;
            for (Datum o : ((LispVector)d).getList()) {
                cnt.set(i, IntLispUtils.toJavaInstance(cc, o));
                ++i;
            }
            return cnt.toObject();
        }
        if (d instanceof JavaInstance) {
            return ((JavaInstance)d).getJavaInstance();
        }
        if (d == JavaNull.JAVA_NULL) {
            return null;
        }
        if (d == Nil.NIL) {
            return new ReflContainer(cl, 0).toObject();
        }
        throw new ClassCastException(cl.getName());
    }

    static Object[] toJavaInstances(Class<?>[] cl, List<Datum> ld, boolean varargs) {
        Object rst;
        Object[] res = new Object[cl.length];
        if (!varargs && cl.length != ld.size()) {
            throw new ClassCastException();
        }
        if (varargs) {
            Class<?> lcl = cl[cl.length - 1];
            if (!lcl.isArray()) {
                throw new RuntimeException();
            }
            res[cl.length - 1] = rst = Array.newInstance(lcl.getComponentType(), ld.size() - cl.length + 1);
        } else {
            rst = null;
        }
        int i = 0;
        while (i < ld.size()) {
            Class<?> lcl = cl[cl.length - 1];
            Class<?> lcc = lcl.getComponentType();
            if (varargs && i >= cl.length - 1) {
                Array.set(rst, i - cl.length + 1, IntLispUtils.toJavaInstance(lcc, ld.get(i)));
            } else if (IntLispUtils.isSameClass(cl[i], ld.get(i))) {
                res[i] = IntLispUtils.toJavaInstance(cl[i], ld.get(i));
            }
            ++i;
        }
        return res;
    }

    static Object newInstance(Class<?> klass, List<Datum> lst) throws IntPrmNotFoundException {
        Constructor<?>[] cns = klass.getConstructors();
        int i = 0;
        while (i < cns.length) {
            boolean va;
            Class<?>[] cls = cns[i].getParameterTypes();
            if (IntLispUtils.isSameClasses(cls, lst, va = cns[i].isVarArgs())) {
                Object[] args = IntLispUtils.toJavaInstances(cls, lst, va);
                try {
                    return cns[i].newInstance(args);
                }
                catch (IllegalArgumentException e) {
                    throw new JavaException(e);
                }
                catch (InstantiationException e) {
                    throw new JavaException(e);
                }
                catch (IllegalAccessException e) {
                    throw new JavaException(e);
                }
                catch (InvocationTargetException e) {
                    throw new JavaTargetException(e.getCause());
                }
            }
            ++i;
        }
        throw new IntPrmNotFoundException();
    }

    static Object invoke(Method mtd, Object obj, Object ... args) throws IntPrmNotFoundException {
        try {
            Object res = mtd.invoke(obj, args);
            if (mtd.getReturnType().isAssignableFrom(Void.TYPE)) {
                return Undef.UNDEF;
            }
            return res == null ? JavaNull.JAVA_NULL : res;
        }
        catch (IllegalArgumentException e) {
            throw new JavaException(e);
        }
        catch (IllegalAccessException e) {
            throw new JavaException(e);
        }
        catch (InvocationTargetException e) {
            throw new JavaTargetException(e.getCause());
        }
        catch (NullPointerException e) {
            throw new IntPrmNotFoundException();
        }
    }

    private static Object invokeMethod0(Method mth, Object obj, List<Datum> lst) throws IntPrmNotFoundException {
        boolean va;
        Class<?>[] cls = mth.getParameterTypes();
        if (IntLispUtils.isSameClasses(cls, lst, va = mth.isVarArgs())) {
            Object[] args = IntLispUtils.toJavaInstances(cls, lst, va);
            return IntLispUtils.invoke(mth, obj, args);
        }
        return NOTFOUND;
    }

    static Object invokeMethod(Method mth, Object obj, List<Datum> lst) throws IntPrmNotFoundException {
        Object res = IntLispUtils.invokeMethod0(mth, obj, lst);
        if (res == NOTFOUND) {
            throw new IntPrmNotFoundException();
        }
        return res;
    }

    static Object invokeMethod(Class<?> klass, Object obj, String name, List<Datum> lst) throws IntPrmNotFoundException {
        Method[] cns = klass.getMethods();
        int i = 0;
        while (i < cns.length) {
            Object res;
            String cnm = cns[i].getName();
            if (cnm.equals(name) && (res = IntLispUtils.invokeMethod0(cns[i], obj, lst)) != NOTFOUND) {
                return res;
            }
            ++i;
        }
        throw new IntPrmNotFoundException();
    }

    static Object invokeGetter(Object obj, PropertyDescriptor pd) throws IntPrmNotFoundException {
        Method mtd = pd.getReadMethod();
        if (mtd == null) {
            throw new IntPrmNotFoundException();
        }
        Class<?>[] prm = mtd.getParameterTypes();
        if (prm.length != 0) {
            throw new IntPrmNotFoundException();
        }
        return IntLispUtils.invoke(mtd, obj, new Object[0]);
    }

    static Object invokeGetter(Object obj, String prop) throws IntrospectionException, IntPrmNotFoundException {
        PropertyDescriptor pd = new PropertyDescriptor(prop, obj.getClass());
        return IntLispUtils.invokeGetter(obj, pd);
    }

    static Object invokeSetter(Object obj, PropertyDescriptor pd, Datum d) throws IntPrmNotFoundException {
        Method mtd = pd.getWriteMethod();
        if (mtd == null) {
            throw new IntPrmNotFoundException();
        }
        Class<?>[] prm = mtd.getParameterTypes();
        if (prm.length != 1 || !IntLispUtils.isSameClass(prm[0], d)) {
            throw new IntPrmNotFoundException();
        }
        return IntLispUtils.invoke(mtd, obj, IntLispUtils.toJavaInstance(prm[0], d));
    }

    static Object invokeSetter(Object obj, String prop, Datum d) throws IntrospectionException, IntPrmNotFoundException {
        PropertyDescriptor pd = new PropertyDescriptor(prop, obj.getClass());
        return IntLispUtils.invokeSetter(obj, pd, d);
    }

    static Object invokeGetter(Object obj, IndexedPropertyDescriptor pd, int index) throws IntPrmNotFoundException {
        Method mtd = pd.getIndexedReadMethod();
        if (mtd == null) {
            throw new IntPrmNotFoundException();
        }
        Class<?>[] prm = mtd.getParameterTypes();
        if (prm.length != 1 || !IntLispUtils.isAssignableInt(prm[0])) {
            throw new IntPrmNotFoundException();
        }
        return IntLispUtils.invoke(mtd, obj, index);
    }

    static Object invokeGetter(Object obj, String prop, int index) throws IntrospectionException, IntPrmNotFoundException {
        IndexedPropertyDescriptor pd = new IndexedPropertyDescriptor(prop, obj.getClass());
        return IntLispUtils.invokeGetter(obj, pd, index);
    }

    static Object invokeSetter(Object obj, IndexedPropertyDescriptor pd, int index, Datum d) throws IntPrmNotFoundException {
        Method mtd = pd.getIndexedWriteMethod();
        if (mtd == null) {
            throw new IntPrmNotFoundException();
        }
        Class<?>[] prm = mtd.getParameterTypes();
        if (prm.length != 2 || !IntLispUtils.isAssignableInt(prm[0]) || !IntLispUtils.isSameClass(prm[1], d)) {
            throw new IntPrmNotFoundException();
        }
        return IntLispUtils.invoke(mtd, obj, index, IntLispUtils.toJavaInstance(prm[1], d));
    }

    static Object invokeSetter(Object obj, String prop, int index, Datum d) throws IntrospectionException, IntPrmNotFoundException {
        IndexedPropertyDescriptor pd = new IndexedPropertyDescriptor(prop, obj.getClass());
        return IntLispUtils.invokeSetter(obj, pd, index, d);
    }

    static Object getField(Object obj, String field) throws NoSuchFieldException {
        try {
            Field f = obj.getClass().getField(field);
            return f.get(obj);
        }
        catch (SecurityException e) {
            throw new JavaException(e);
        }
        catch (IllegalArgumentException e) {
            throw new JavaException(e);
        }
        catch (IllegalAccessException e) {
            throw new JavaException(e);
        }
    }

    static void setField(Object obj, String field, Datum d) throws NoSuchFieldException, IntPrmNotFoundException {
        try {
            Field f = obj.getClass().getField(field);
            if (!IntLispUtils.isSameClass(f.getType(), d)) {
                throw new IntPrmNotFoundException();
            }
            Object dj = IntLispUtils.toJavaInstance(f.getType(), d);
            f.set(obj, dj);
        }
        catch (IllegalArgumentException e) {
            throw new JavaException(e);
        }
        catch (IllegalAccessException e) {
            throw new JavaException(e);
        }
    }

    static boolean isSymbolName(Datum d) {
        return d instanceof SymbolName;
    }

    static void timelog(Logger _log, String str, long bef) {
        long dt = System.currentTimeMillis() - bef;
        String msec = "000" + dt % 1000L;
        msec = msec.substring(msec.length() - 3);
        _log.fine(String.valueOf(str) + dt / 1000L + "." + msec + "sec");
    }

    static void timelogFiner(Logger _log, String str, long bef) {
        long dt = System.currentTimeMillis() - bef;
        String msec = "000" + dt % 1000L;
        msec = msec.substring(msec.length() - 3);
        _log.finer(String.valueOf(str) + dt / 1000L + "." + msec + "sec");
    }

    static void loadJavaSubr(Environment env, Symbol k, String v) {
        env.bindDatum(k, IntLispUtils.getJavaSubr(k, v));
    }

    static Datum getJavaSubr(Symbol k, String v) {
        try {
            Class<?> cls = Class.forName(v);
            Datum ins = (Datum)cls.newInstance();
            if (ins instanceof Subr) {
                ((Subr)ins).symbolName = k.getName();
            } else if (ins instanceof Syntax) {
                ((Syntax)ins).symbolName = k.getName();
            }
            return ins;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

