/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispNotSupportedException;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.sos.LispType;

public final class LispComplex
extends LispNumber {
    public static final LispComplex I = new LispComplex(0.0, 1.0);
    public static final LispComplex MINUS_I = new LispComplex(0.0, -1.0);
    private double real;
    private double imag;

    private LispComplex(double r, double i) {
        this.real = r;
        this.imag = i;
    }

    @Override
    public double getRealDouble() {
        return this.real;
    }

    @Override
    public LispReal getReal() {
        return new LispDouble(this.real);
    }

    @Override
    public double getImagDouble() {
        return this.imag;
    }

    @Override
    public LispReal getImag() {
        return new LispDouble(this.imag);
    }

    public static LispNumber newComplex(double r, double i) {
        if (i == 0.0) {
            return new LispDouble(r);
        }
        if (Double.isNaN(r) || Double.isNaN(i)) {
            return LispDouble.NaN;
        }
        return new LispComplex(r, i);
    }

    @Override
    public LispNumber add(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex(this.real + c.real, this.imag + c.imag);
        }
        if (x instanceof LispReal) {
            return LispComplex.newComplex(this.real + x.getRealDouble(), this.imag);
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber div(LispNumber x) {
        if (x instanceof LispComplex) {
            double xr = ((LispComplex)x).real;
            double xi = ((LispComplex)x).imag;
            if (xr == 0.0) {
                return LispComplex.newComplex(this.imag / xi, -this.real / xi);
            }
            return LispComplex.newComplex((this.real * xr + this.imag * xi) / (xr * xr + xi * xi), (this.imag * xr - this.real * xi) / (xr * xr + xi * xi));
        }
        if (x instanceof LispReal) {
            double r = x.getRealDouble();
            return LispComplex.newComplex(this.real / r, this.imag / r);
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public boolean isEqualTo(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return this.real == c.real && this.imag == c.imag;
        }
        if (x instanceof LispReal) {
            return false;
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isRational() {
        return false;
    }

    @Override
    public boolean isReal() {
        return false;
    }

    @Override
    public LispNumber mul(LispNumber x) {
        if (x instanceof LispComplex) {
            double xr = ((LispComplex)x).real;
            double xi = ((LispComplex)x).imag;
            if (xr == 0.0) {
                return LispComplex.newComplex(-this.imag * xi, this.real * xi);
            }
            return LispComplex.newComplex(this.real * xr - this.imag * xi, this.imag * xr + this.real * xi);
        }
        if (x instanceof LispReal) {
            double r = x.getRealDouble();
            return LispComplex.newComplex(this.real * r, this.imag * r);
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber sub(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex(this.real - c.real, this.imag - c.imag);
        }
        if (x instanceof LispReal) {
            return LispComplex.newComplex(this.real - x.getRealDouble(), this.imag);
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber uminus() {
        return LispComplex.newComplex(-this.real, -this.imag);
    }

    @Override
    public String getResult() {
        if (this.imag > 0.0 && this.imag != Double.POSITIVE_INFINITY) {
            return String.valueOf(LispNumber.disp(this.real)) + "+" + LispNumber.disp(this.imag) + "i";
        }
        return String.valueOf(LispNumber.disp(this.real)) + LispNumber.disp(this.imag) + "i";
    }

    @Override
    public String print() {
        return this.getResult();
    }

    @Override
    public boolean isExact() {
        return false;
    }

    @Override
    public LispNumber toExact() {
        throw new LispNotSupportedException("err.notsupported.exactcomplex");
    }

    @Override
    public LispNumber toInexact() {
        return this;
    }

    @Override
    public LispString toLispString(int radix) {
        if (radix < 2 || radix > 36) {
            throw new IndexOutOfBoundsException("radix is out of range");
        }
        if (radix != 10) {
            throw new IllegalArgumentException("radix except 10 is not supported");
        }
        if (this.imag > 0.0 && this.imag != Double.POSITIVE_INFINITY) {
            return new LispString(String.valueOf(LispNumber.disp(this.real)) + "+" + LispNumber.disp(this.imag) + "i");
        }
        return new LispString(String.valueOf(LispNumber.disp(this.real)) + LispNumber.disp(this.imag) + "i");
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.real) || Double.isNaN(this.imag);
    }

    @Override
    public boolean isOne() {
        return this.real == 1.0 && this.imag == 0.0;
    }

    @Override
    public BigInteger getBigInteger() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger getDenominator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal getBigDecimal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger getNumerator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public LispType getType() {
        return LispType.COMPLEX;
    }

    public boolean equals(Object x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return this.real == c.real && this.imag == c.imag;
        }
        return false;
    }

    public int hashCode() {
        int l = 17;
        long lr = Double.doubleToLongBits(this.real);
        long li = Double.doubleToLongBits(this.imag);
        l = 37 * l + (int)(lr ^ lr >>> 32);
        l = 37 * l + (int)(li ^ li >>> 32);
        return l;
    }

    @Override
    public String toString() {
        return this.getResult();
    }
}

