/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.morilib.lang.number.AbstractNumericalField;
import net.morilib.lang.number.Integer2;
import net.morilib.lang.number.NumericalField;
import net.morilib.lang.number.Rational;
import net.morilib.lisp.IntLispUtils;
import net.morilib.lisp.JavaObjective;
import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispExactReal;
import net.morilib.lisp.LispNotSupportedException;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.sos.LispType;

public final class LispDouble
extends LispReal
implements JavaObjective {
    public static final NumericalField<LispReal> FIELD = new AbstractNumericalField<LispReal>(){

        @Override
        public LispReal valueOf(int v) {
            return this.valueOf((double)v);
        }

        @Override
        public LispReal valueOf(long v) {
            return this.valueOf((double)v);
        }

        @Override
        public LispReal valueOf(Integer2 v) {
            return this.valueOf(v.doubleValue());
        }

        @Override
        public LispReal getUnit() {
            return ONE;
        }

        @Override
        public LispReal getZero() {
            return ZERO;
        }

        @Override
        public LispReal valueOf(float v) {
            return this.valueOf((double)v);
        }

        @Override
        public LispReal valueOf(double v) {
            return new LispDouble(v);
        }

        @Override
        public LispReal valueOf(BigDecimal v) {
            return this.valueOf(v.doubleValue());
        }

        @Override
        public LispReal valueOf(Rational v) {
            return this.valueOf(v.doubleValue());
        }
    };
    public static final LispDouble ZERO = new LispDouble(0.0);
    public static final LispDouble ONE = new LispDouble(1.0);
    public static final LispDouble POSITIVE_INFINITY = new LispDouble(Double.POSITIVE_INFINITY);
    public static final LispDouble NEGATIVE_INFINITY = new LispDouble(Double.NEGATIVE_INFINITY);
    public static final LispDouble NaN = new LispDouble(Double.NaN);
    private double number;

    public LispDouble(double x) {
        this.number = x;
    }

    public static LispExactReal toExact(double val) {
        if (Double.isInfinite(val) || Double.isNaN(val)) {
            throw new LispNotSupportedException("err.notsupported.exactinfinity");
        }
        BigDecimal v = BigDecimal.valueOf(val);
        return LispUtils.bigDecimalToRational(v);
    }

    @Override
    public BigInteger getNumerator() {
        LispExactReal r = LispDouble.toExact(this.number);
        return r.getNumerator();
    }

    @Override
    public BigInteger getDenominator() {
        LispExactReal r = LispDouble.toExact(this.number);
        return r.getDenominator();
    }

    @Override
    public LispNumber add(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex(this.number + c.getRealDouble(), c.getImagDouble());
        }
        if (x instanceof LispReal) {
            return new LispDouble(this.number + x.getRealDouble());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber sub(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            return LispComplex.newComplex(this.number - c.getRealDouble(), -c.getImagDouble());
        }
        if (x instanceof LispReal) {
            return new LispDouble(this.number - x.getRealDouble());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber mul(LispNumber x) {
        if (x instanceof LispComplex) {
            LispComplex c = (LispComplex)x;
            if (c.getRealDouble() == 0.0) {
                return LispComplex.newComplex(0.0, this.number * c.getImagDouble());
            }
            return LispComplex.newComplex(this.number * c.getRealDouble(), this.number * c.getImagDouble());
        }
        if (x instanceof LispReal) {
            return new LispDouble(this.number * x.getRealDouble());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber div(LispNumber x) {
        if (x instanceof LispComplex) {
            double xr = ((LispComplex)x).getRealDouble();
            double xi = ((LispComplex)x).getImagDouble();
            if (xr == 0.0) {
                return LispComplex.newComplex(0.0, -this.number / xi);
            }
            return LispComplex.newComplex(this.number * xr / (xr * xr + xi * xi), -(this.number * xi) / (xr * xr + xi * xi));
        }
        if (x instanceof LispReal) {
            return new LispDouble(this.number / x.getRealDouble());
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public LispNumber uminus() {
        return new LispDouble(-this.number);
    }

    @Override
    public boolean isEqualTo(LispNumber x) {
        if (x instanceof LispComplex) {
            return false;
        }
        if (x instanceof LispReal) {
            return this.number == x.getRealDouble();
        }
        throw new IllegalArgumentException(x.toString());
    }

    @Override
    public boolean isLessThan(LispReal x) {
        return this.number < x.getRealDouble();
    }

    @Override
    public boolean isMoreThan(LispReal x) {
        return this.number > x.getRealDouble();
    }

    public BigInteger bigIntegerValue() {
        BigDecimal dec = new BigDecimal(this.number);
        return dec.toBigInteger();
    }

    @Override
    public double doubleValue() {
        return this.number;
    }

    @Override
    public int signum() {
        return this.number > 0.0 ? 1 : (this.number < 0.0 ? -1 : 0);
    }

    @Override
    public LispExactReal toExact() {
        return LispDouble.toExact(this.number);
    }

    @Override
    public LispReal toInexact() {
        return this;
    }

    @Override
    public String print() {
        return LispDouble.disp(this.number);
    }

    @Override
    public String getResult() {
        return LispDouble.disp(this.number);
    }

    @Override
    public boolean isInteger() {
        return IntLispUtils.toIntegerExact(this.number) != null;
    }

    @Override
    public boolean isRational() {
        return !Double.isInfinite(this.number) && !Double.isNaN(this.number);
    }

    @Override
    public boolean isReal() {
        return true;
    }

    @Override
    public boolean isExact() {
        return false;
    }

    @Override
    public LispString toLispString(int radix) {
        if (radix < 2 || radix > 36) {
            throw new IndexOutOfBoundsException("radix is out of range");
        }
        if (radix != 10) {
            throw new IllegalArgumentException("radix except 10 is not supported");
        }
        if (Double.isNaN(this.number)) {
            return new LispString("+nan.0");
        }
        if (this.number == Double.POSITIVE_INFINITY) {
            return new LispString("+inf.0");
        }
        if (this.number == Double.NEGATIVE_INFINITY) {
            return new LispString("-inf.0");
        }
        return new LispString(Double.toString(this.number));
    }

    @Override
    public boolean isNaN() {
        return Double.isNaN(this.number);
    }

    @Override
    public boolean isOne() {
        return this.number == 1.0;
    }

    @Override
    public BigInteger getBigInteger() {
        return this.getBigDecimal().toBigInteger();
    }

    @Override
    public int getInt() {
        return this.getBigInteger().intValue();
    }

    @Override
    public long getLong() {
        return this.getBigInteger().longValue();
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (Double.isInfinite(this.number) || Double.isNaN(this.number)) {
            throw new NumberFormatException("Infinities or NaNs is not supported");
        }
        return BigDecimal.valueOf(this.number);
    }

    @Override
    public double getRealDouble() {
        return this.number;
    }

    @Override
    public LispType getType() {
        return LispType.REAL;
    }

    @Override
    public boolean isInfinity() {
        return Double.isInfinite(this.number);
    }

    @Override
    public LispReal invert() {
        return new LispDouble(1.0 / this.number);
    }

    @Override
    public boolean isUnit() {
        return this.number == 1.0;
    }

    @Override
    public LispReal multiply(int n) {
        return new LispDouble(this.number * (double)n);
    }

    @Override
    public LispReal power(int n) {
        return new LispDouble(Math.pow(this.number, n));
    }

    @Override
    public NumericalField<LispReal> getUniverse() {
        return FIELD;
    }

    @Override
    public int intFloor() {
        return (int)this.longFloor();
    }

    @Override
    public long longFloor() {
        return (long)Math.floor(this.number);
    }

    @Override
    public Integer2 getInteger2Floor() {
        Rational r = Rational.valueOf(this.number);
        return r.getInteger2Floor();
    }

    @Override
    public int intCeil() {
        return (int)this.longCeil();
    }

    @Override
    public long longCeil() {
        return (long)Math.ceil(this.number);
    }

    @Override
    public Integer2 getInteger2Ceil() {
        Rational r = Rational.valueOf(this.number);
        return r.getInteger2Ceil();
    }

    @Override
    public Rational getRational() {
        return LispDouble.toExact(this.number).getRational();
    }

    @Override
    public float floatValue() {
        return (float)this.number;
    }

    @Override
    public Object toObject() {
        return new Double(this.number);
    }

    public boolean equals(Object x) {
        if (x instanceof LispDouble) {
            return this.number == ((LispDouble)x).number;
        }
        return false;
    }

    public int hashCode() {
        int l = 17;
        long lr = Double.doubleToLongBits(this.number);
        l = 37 * l + (int)(lr ^ lr >>> 32);
        return l;
    }

    @Override
    public String toString() {
        return Double.toString(this.number);
    }
}

