/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.math.BigDecimal;
import net.morilib.lang.number.AbstractNumericalField;
import net.morilib.lang.number.Integer2;
import net.morilib.lang.number.NumericalField;
import net.morilib.lang.number.Rational;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispRational;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.sos.LispType;

public abstract class LispExactReal
extends LispReal {
    private static final NumericalField<LispReal> _FIELDR = new AbstractNumericalField<LispReal>(){

        @Override
        public LispReal valueOf(float v) {
            return LispDouble.toExact(v);
        }

        @Override
        public LispReal valueOf(double v) {
            return LispDouble.toExact(v);
        }

        @Override
        public LispReal valueOf(BigDecimal v) {
            return LispUtils.bigDecimalToRational(v);
        }

        @Override
        public LispReal valueOf(Rational v) {
            return LispRational.valueOf(v);
        }

        @Override
        public LispReal valueOf(int v) {
            return LispInteger.valueOf(v);
        }

        @Override
        public LispReal valueOf(long v) {
            return LispInteger.valueOf(v);
        }

        @Override
        public LispReal valueOf(Integer2 v) {
            return LispInteger.valueOf(v.toBigInteger());
        }

        @Override
        public LispReal getUnit() {
            return LispInteger.ONE;
        }

        @Override
        public LispReal getZero() {
            return LispInteger.ZERO;
        }
    };

    public abstract Rational toRational();

    @Override
    public LispExactReal toExact() {
        return this;
    }

    @Override
    public boolean isNaN() {
        return false;
    }

    @Override
    public boolean isInfinity() {
        return false;
    }

    @Override
    public LispType getType() {
        return LispType.REAL;
    }

    @Override
    public LispReal multiply(int n) {
        return this.multiply(new LispSmallInt(n));
    }

    @Override
    public LispReal power(int n) {
        if (n < 0) {
            return (LispReal)this.power(-n).invert();
        }
        if (n == 0) {
            return LispInteger.ONE;
        }
        if (n == 1) {
            return this;
        }
        LispReal r = this;
        int i = 1;
        while (i < n) {
            r = r.multiply(this);
            ++i;
        }
        return r;
    }

    @Override
    public NumericalField<LispReal> getUniverse() {
        return _FIELDR;
    }
}

