/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.morilib.lisp.Atom;
import net.morilib.lisp.Closure;
import net.morilib.lisp.ClosureClass;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Continuation;
import net.morilib.lisp.Datum;
import net.morilib.lisp.EOFObject;
import net.morilib.lisp.EnvironmentObject;
import net.morilib.lisp.InputPort;
import net.morilib.lisp.JavaClass;
import net.morilib.lisp.JavaInstance;
import net.morilib.lisp.JavaNull;
import net.morilib.lisp.Keyword;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispExactReal;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispRational;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Macro;
import net.morilib.lisp.MultiValues;
import net.morilib.lisp.NamableDatum;
import net.morilib.lisp.Nil;
import net.morilib.lisp.OutputPort;
import net.morilib.lisp.Promise;
import net.morilib.lisp.RegexPattern;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.SymbolName;
import net.morilib.lisp.SymbolScope;
import net.morilib.lisp.Syntax;
import net.morilib.lisp.Undef;
import net.morilib.lisp.UserSyntax;

public final class LispUtils {
    private LispUtils() {
    }

    private static void printBodyAux1(Cons c, StringBuilder buf, boolean met, String disp) {
        Cons cd;
        if (c.getCdr() instanceof Cons && (cd = (Cons)c.getCdr()).getCdr() == Nil.NIL) {
            buf.append(disp);
            LispUtils.printBody(cd.getCar(), buf, met);
        }
    }

    private static void printBody(Datum d, StringBuilder buf, boolean met) {
        if (d instanceof Atom) {
            Atom a = (Atom)d;
            buf.append(met ? a.getResult() : a.print());
        } else if (d == Nil.NIL) {
            buf.append("()");
        } else if (d == Undef.UNDEF) {
            buf.append("#<undef>");
        } else if (d instanceof Cons) {
            Cons c = (Cons)d;
            if (Symbol.QUOTE.equals(c.getCar())) {
                LispUtils.printBodyAux1(c, buf, met, "'");
            } else if (Symbol.QUASIQUOTE.equals(c.getCar())) {
                LispUtils.printBodyAux1(c, buf, met, "`");
            } else if (Symbol.UNQUOTE.equals(c.getCar())) {
                LispUtils.printBodyAux1(c, buf, met, ",");
            } else if (Symbol.UNQUOTE_SPLICING.equals(c.getCar())) {
                LispUtils.printBodyAux1(c, buf, met, ",@");
            } else {
                block67: {
                    HashSet<Cons> jn = new HashSet<Cons>();
                    buf.append("(");
                    while (true) {
                        LispUtils.printBody(c.getCar(), buf, met);
                        if (!(c.getCdr() instanceof Cons)) break;
                        if (jn.contains(c)) {
                            buf.append(" ...");
                            break block67;
                        }
                        jn.add(c);
                        buf.append(" ");
                        c = (Cons)c.getCdr();
                    }
                    if (c.getCdr() != Nil.NIL) {
                        buf.append(" . ");
                        LispUtils.printBody(c.getCdr(), buf, met);
                    }
                }
                buf.append(")");
            }
        } else if (d instanceof LispVector) {
            LispVector v = (LispVector)d;
            buf.append("#(");
            int i = 0;
            while (i < v.size()) {
                if (i > 0) {
                    buf.append(" ");
                }
                LispUtils.printBody(v.get(i), buf, met);
                ++i;
            }
            buf.append(")");
        } else if (d instanceof ClosureClass) {
            buf.append("#<closureClass" + d + ">");
        } else if (d instanceof Closure) {
            buf.append("#<closure " + ((Closure)d).printName() + ">");
        } else if (d instanceof Continuation) {
            buf.append("#<continuation " + Integer.toString(d.hashCode(), 16) + ">");
        } else if (d instanceof Subr) {
            buf.append("#<subr " + ((Subr)d).getSymbolName() + ">");
        } else if (d instanceof Syntax) {
            buf.append("#<syntax " + ((Syntax)d).getSymbolName() + ">");
        } else if (d instanceof UserSyntax) {
            buf.append("#<syntax " + ((UserSyntax)d).getName() + ">");
        } else if (d instanceof Macro) {
            buf.append("#<macro>");
        } else if (d instanceof Promise) {
            buf.append("#<promise " + d + ">");
        } else if (d == EOFObject.EOF) {
            buf.append("#<eof>");
        } else if (d instanceof InputPort) {
            buf.append("#<iport>");
        } else if (d instanceof OutputPort) {
            buf.append("#<oport>");
        } else if (d instanceof MultiValues) {
            List<Datum> lst = ((MultiValues)d).getValues();
            int i = 0;
            while (i < lst.size()) {
                if (i > 0) {
                    buf.append("\n");
                }
                LispUtils.printBody(lst.get(i), buf, met);
                ++i;
            }
        } else if (d instanceof EnvironmentObject) {
            buf.append("#<environment>");
        } else if (d instanceof JavaClass) {
            buf.append("#<java-class>");
        } else if (d instanceof JavaInstance) {
            Object o = ((JavaInstance)d).getJavaInstance();
            buf.append("#<java-instance ");
            buf.append(o.getClass().getName());
            buf.append(">");
        } else if (d == JavaNull.JAVA_NULL) {
            buf.append("#<java-null>");
        } else if (d instanceof SymbolScope) {
            SymbolScope d2 = (SymbolScope)d;
            Symbol a = d2.getSymbol();
            buf.append(met ? a.getResult() : a.print());
        } else if (d instanceof RegexPattern) {
            buf.append("#<regexp " + ((RegexPattern)d).getPatternString() + ">");
        } else if (d instanceof RegexPattern.Match) {
            buf.append("#<rxmatch " + ((RegexPattern.Match)d).toStringRepl() + ">");
        } else if (d instanceof Keyword) {
            buf.append(":" + ((Keyword)d).getName());
        } else if (d instanceof NamableDatum) {
            buf.append(((NamableDatum)d).display());
        } else {
            d.toDisplayString(buf);
        }
    }

    public static String print(Datum d) {
        StringBuilder buf = new StringBuilder();
        LispUtils.printBody(d, buf, false);
        return buf.toString();
    }

    public static String getResult(Datum d) {
        StringBuilder buf = new StringBuilder();
        LispUtils.printBody(d, buf, true);
        return buf.toString();
    }

    public static Datum listToCons(List<Datum> d, Datum dot) {
        Cons res = null;
        Cons c2 = null;
        int i = 0;
        while (i < d.size()) {
            if (res == null) {
                res = c2 = new Cons();
                c2.setCar(d.get(i));
            } else {
                Cons c3 = new Cons(d.get(i), Nil.NIL);
                c2.setCdr(c3);
                c2 = c3;
            }
            ++i;
        }
        if (res == null) {
            return dot;
        }
        c2.setCdr(dot);
        return res;
    }

    public static Datum listToCons(List<Datum> d) {
        return LispUtils.listToCons(d, Nil.NIL);
    }

    public static List<Datum> consToList(Datum d, LispMessage mesg) {
        ArrayList<Datum> res = new ArrayList<Datum>();
        Datum dd = d;
        while (dd != Nil.NIL) {
            if (dd instanceof Cons) {
                res.add(((Cons)dd).getCar());
                dd = ((Cons)dd).getCdr();
                continue;
            }
            throw mesg.getError("err.list");
        }
        return res;
    }

    public static List<Datum> consToListIgnoreDot(Datum d) {
        ArrayList<Datum> res = new ArrayList<Datum>();
        Datum dd = d;
        while (dd != Nil.NIL) {
            if (!(dd instanceof Cons)) break;
            res.add(((Cons)dd).getCar());
            dd = ((Cons)dd).getCdr();
        }
        return res;
    }

    public static int consLength(Datum d) {
        Datum p = d;
        int len = 0;
        while (p != Nil.NIL) {
            if (p instanceof Cons) {
                Cons c = (Cons)p;
                ++len;
                p = c.getCdr();
                continue;
            }
            return len;
        }
        return len;
    }

    public static List<Datum> toList(Object[] arr) {
        ArrayList<Datum> lst = new ArrayList<Datum>();
        Object[] objectArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            lst.add(LispUtils.toDatum(o));
            ++n2;
        }
        return lst;
    }

    public static Datum toConsList(Object[] arr, Object cdr) {
        ConsListBuilder lst = new ConsListBuilder();
        Object[] objectArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            lst.append(LispUtils.toDatum(o));
            ++n2;
        }
        return lst.get(LispUtils.toDatum(cdr));
    }

    public static Datum toConsList(Object[] arr) {
        return LispUtils.toConsList(arr, Nil.NIL);
    }

    public static LispExactReal bigDecimalToRational(BigDecimal v) {
        BigInteger n = v.unscaledValue();
        if (v.scale() > 0) {
            BigInteger d = BigInteger.TEN.pow(v.scale());
            return LispRational.newRational(n, d);
        }
        if (v.scale() < 0) {
            BigInteger d = BigInteger.TEN.pow(-v.scale());
            return LispInteger.valueOf(n.multiply(d));
        }
        return LispInteger.valueOf(n);
    }

    public static Datum toDatum(Object o) {
        Class<?> cl;
        Class<?> clazz = cl = o == null ? null : o.getClass();
        if (o == null) {
            return JavaNull.JAVA_NULL;
        }
        if (o instanceof Datum) {
            return (Datum)o;
        }
        if (o instanceof Integer) {
            return LispInteger.valueOf((Integer)o);
        }
        if (o instanceof Long) {
            return LispInteger.valueOf((Long)o);
        }
        if (o instanceof BigInteger) {
            return LispInteger.valueOf((BigInteger)o);
        }
        if (o instanceof BigDecimal) {
            return LispUtils.bigDecimalToRational((BigDecimal)o);
        }
        if (o instanceof Float) {
            return new LispDouble(((Float)o).doubleValue());
        }
        if (o instanceof Double) {
            return new LispDouble((Double)o);
        }
        if (o instanceof String) {
            return new LispString((String)o);
        }
        if (o instanceof Character) {
            return new LispCharacter(((Character)o).charValue());
        }
        if (o instanceof Boolean) {
            return LispBoolean.getInstance((Boolean)o);
        }
        if (cl.isArray()) {
            ConsListBuilder bld = new ConsListBuilder();
            int len = Array.getLength(o);
            int i = 0;
            while (i < len) {
                bld.append(LispUtils.toDatum(Array.get(o, i)));
                ++i;
            }
            return bld.get();
        }
        return new JavaInstance(o);
    }

    public static boolean eqv(Datum d1, Datum d2) {
        return !LispBoolean.FALSE.equals(d1.isEqv(d2));
    }

    public static boolean equals(Datum d, String o) {
        if (d instanceof LispString) {
            return ((LispString)d).getString().equals(o);
        }
        return false;
    }

    public static boolean eqvExact(Datum d, BigInteger v) {
        if (d instanceof LispInteger) {
            return d.getBigInteger().equals(v);
        }
        return false;
    }

    public static boolean eqvExact(Datum d, int v) {
        return LispUtils.eqvExact(d, BigInteger.valueOf(v));
    }

    public static boolean eqvExact(Datum d, long v) {
        return LispUtils.eqvExact(d, BigInteger.valueOf(v));
    }

    public static boolean eqvInexact(Datum d, double v) {
        if (d instanceof LispReal) {
            return ((LispReal)d).getRealDouble() == v;
        }
        return false;
    }

    public static boolean eqvInexact(Datum d, Number v) {
        return LispUtils.eqvInexact(d, v.doubleValue());
    }

    public static boolean eqvInexact(Datum d, int v) {
        return LispUtils.eqvInexact(d, (double)v);
    }

    public static boolean eqvInexact(Datum d, long v) {
        return LispUtils.eqvInexact(d, (double)v);
    }

    public static Datum listDot(Object d, Object ... lst) {
        ConsListBuilder b = new ConsListBuilder();
        Object[] objectArray = lst;
        int n = lst.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            b.append(LispUtils.toDatum(o));
            ++n2;
        }
        return b.get(LispUtils.toDatum(d));
    }

    public static Datum list(Object ... lst) {
        return LispUtils.listDot((Object)Nil.NIL, lst);
    }

    public static Datum listDot(Datum d, Datum ... lst) {
        ConsListBuilder b = new ConsListBuilder();
        Datum[] datumArray = lst;
        int n = lst.length;
        int n2 = 0;
        while (n2 < n) {
            Datum o = datumArray[n2];
            b.append(o);
            ++n2;
        }
        return b.get(d);
    }

    public static Datum list(Datum ... lst) {
        return LispUtils.listDot(Nil.NIL, lst);
    }

    public static Cons cons(Object car, Object cdr) {
        return new Cons(LispUtils.toDatum(car), LispUtils.toDatum(cdr));
    }

    public static LispVector vector(Object ... lst) {
        ArrayList<Datum> v = new ArrayList<Datum>();
        Object[] objectArray = lst;
        int n = lst.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            v.add(LispUtils.toDatum(o));
            ++n2;
        }
        return new LispVector(v);
    }

    public static boolean equalsVector(LispVector v1, LispVector v2) {
        if (v1.size() != v2.size()) {
            return false;
        }
        int i = 0;
        while (i < v1.size()) {
            if (!LispUtils.equals(v1.get(i), v2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(Datum d1, Datum d2) {
        Datum p = d1;
        Datum q = d2;
        while (p instanceof Cons) {
            Cons pc = (Cons)p;
            if (q instanceof Cons) {
                Cons qc = (Cons)q;
                if (LispUtils.equals(pc.getCar(), qc.getCar())) {
                    p = pc.getCdr();
                    q = qc.getCdr();
                    continue;
                }
                return false;
            }
            return false;
        }
        if (p instanceof LispString) {
            if (q instanceof LispString) {
                String s1 = ((LispString)p).getString();
                String s2 = ((LispString)q).getString();
                return s1.equals(s2);
            }
            return false;
        }
        if (p instanceof LispVector) {
            if (q instanceof LispVector) {
                return LispUtils.equalsVector((LispVector)p, (LispVector)q);
            }
            return false;
        }
        return p.isEqv(q);
    }

    public static Map<Datum, Datum> assocToMap(Datum d) {
        HashMap<Datum, Datum> res = new HashMap<Datum, Datum>();
        ConsIterator p = new ConsIterator(d);
        while (p.hasNext()) {
            Datum c = p.next();
            if (c instanceof Cons) {
                Cons c0 = (Cons)c;
                res.put(c0.getCar(), c0.getCdr());
                continue;
            }
            return null;
        }
        return p.getTerminal() == Nil.NIL ? res : null;
    }

    public static Map<Symbol, Datum> assocToMapSymbol(Datum d) {
        HashMap<Symbol, Datum> res = new HashMap<Symbol, Datum>();
        ConsIterator p = new ConsIterator(d);
        while (p.hasNext()) {
            Datum c = p.next();
            if (c instanceof Cons) {
                Cons c0 = (Cons)c;
                if (c0.getCar() instanceof SymbolName) {
                    res.put(((SymbolName)((Object)c0.getCar())).getSymbol(), c0.getCdr());
                    continue;
                }
                return null;
            }
            return null;
        }
        return p.getTerminal() == Nil.NIL ? res : null;
    }

    public static void checkReal(Datum d, LispMessage mesg) {
        if (!(d instanceof LispNumber)) {
            throw mesg.getError("err.require.number", d);
        }
        if (!((LispNumber)d).isReal()) {
            throw mesg.getError("err.require.real", d);
        }
    }

    public static void checkReal(List<Datum> l, int i, LispMessage mesg) {
        LispUtils.checkReal(l.get(i), mesg);
    }

    public static void checkString(Datum d, LispMessage mesg) {
        if (!(d instanceof LispString)) {
            throw mesg.getError("err.require.string", d);
        }
    }

    public static void checkSymbol(Datum d, LispMessage mesg) {
        if (!(d instanceof Symbol)) {
            throw mesg.getError("err.require.symbol", d);
        }
    }
}

