/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import net.morilib.lisp.ClosureClass;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.InputPort;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.UnaryArgs;

public class SubrLoad
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        throw new RuntimeException();
    }

    @Override
    ClosureClass createClosureClass(Environment env) {
        CompiledCode.Builder bld = new CompiledCode.Builder();
        ClosureClass cl1 = new ClosureClass();
        Symbol f = Symbol.getSymbol("f");
        Symbol p = Symbol.getSymbol("p");
        bld.addPush(Aux1.INSTANCE);
        bld.addBeginList();
        bld.addReferSymbol(f);
        bld.addAppendList();
        bld.addEndList();
        bld.addCall();
        bld.addBind(p);
        bld.addReferSymbol(p);
        bld.addOverrideLoadCode();
        bld.addPush(Aux2.INSTANCE);
        bld.addBeginList();
        bld.addReferSymbol(p);
        bld.addAppendList();
        bld.addEndList();
        bld.addCall();
        bld.addPop();
        bld.addPush(Undef.UNDEF);
        bld.addReturnOp();
        cl1.setParameterList(new Cons(f, Nil.NIL));
        cl1.setCode(bld.getCodeRef());
        return cl1;
    }

    private static class Aux1
    extends UnaryArgs {
        private static final Aux1 INSTANCE = new Aux1();

        private Aux1() {
        }

        private File searchPath(String fn, Datum pth, String sep, LispMessage mesg) {
            File ff = new File(fn);
            if (ff.isFile()) {
                return ff;
            }
            ff = new File(String.valueOf(fn) + ".scm");
            if (ff.isFile()) {
                return ff;
            }
            Datum p = pth;
            while (p instanceof Cons) {
                Cons c = (Cons)p;
                if (c.getCar() instanceof LispString) {
                    String p0 = ((LispString)c.getCar()).getString();
                    ff = new File(String.valueOf(p0) + sep + fn);
                    if (ff.isFile()) {
                        return ff;
                    }
                    ff = new File(String.valueOf(p0) + sep + fn + ".scm");
                    if (ff.isFile()) {
                        return ff;
                    }
                }
                p = c.getCdr();
            }
            throw mesg.getError("err.load.filenotfound", fn);
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            Datum pth = env.findDatum(Symbol.getSymbol("*load-path*"));
            if (pth == null) {
                throw mesg.getError("err.unbound", "*load-path*");
            }
            if (c1a instanceof LispString) {
                String fn = ((LispString)c1a).getString();
                String sp = System.getProperty("file.separator");
                File ff = this.searchPath(fn, pth, sp, mesg);
                try {
                    BufferedReader rd = new BufferedReader(new InputStreamReader(new FileInputStream(ff)));
                    return new InputPort(rd, mesg);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            throw mesg.getError("err.reqired.string", c1a);
        }
    }

    private static class Aux2
    extends UnaryArgs {
        private static final Aux2 INSTANCE = new Aux2();

        private Aux2() {
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof InputPort) {
                InputPort ipt = (InputPort)c1a;
                ipt.close();
                return Undef.UNDEF;
            }
            throw mesg.getError("err.require.iport");
        }
    }
}

