/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.ArrayList;
import java.util.List;
import net.morilib.lisp.CodeExecutor;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.IntStack;
import net.morilib.lisp.LispCompiler;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Syntax;
import net.morilib.lisp.SyntaxUtils;
import net.morilib.lisp.Undef;

public class SynCase
extends Syntax {
    private static final Symbol ELSE_SYM = Symbol.getSymbol("else");

    private boolean isElseScope(Datum d) {
        return SyntaxUtils.equalsReserved(ELSE_SYM, d);
    }

    @Override
    void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento, LispCompiler.MiscInfo syncased) {
        block10: {
            Datum d = body;
            int last = build.allocLabel();
            boolean notelse = true;
            if (!(d instanceof Cons)) {
                throw mesg.getError("err.case.malform");
            }
            Cons c0 = (Cons)d;
            comp.compile(c0.getCar(), env, build, callsym, false, symlist, exec, memento, syncased);
            d = c0.getCdr();
            while (true) {
                if (d == Nil.NIL) {
                    if (notelse) {
                        build.addPop();
                        build.addPush(Undef.UNDEF);
                        build.setCurrentAddressToLabel(last);
                    }
                    break block10;
                }
                if (!notelse) {
                    throw mesg.getError("err.else");
                }
                if (!(d instanceof Cons)) break;
                Datum d1 = ((Cons)d).getCar();
                if (!(d1 instanceof Cons)) {
                    throw mesg.getError("err.case.malform", d1);
                }
                Cons d2 = (Cons)d1;
                if (this.isElseScope(d2.getCar())) {
                    build.addPop();
                    SyntaxUtils.compileList(d2.getCdr(), env, comp, build, callsym, istail, mesg, symlist, exec, memento, syncased);
                    build.setCurrentAddressToLabel(last);
                    notelse = false;
                } else {
                    int l1 = build.allocLabel();
                    if (!(d2.getCar() instanceof Cons)) {
                        throw mesg.getError("err.case.malform.key", d2.getCar());
                    }
                    List<Datum> keys = LispUtils.consToList(d2.getCar(), mesg);
                    build.addBeginList();
                    int i = 0;
                    while (i < keys.size()) {
                        build.addPush(keys.get(i));
                        build.addAppendList();
                        ++i;
                    }
                    build.addEndList();
                    build.addFindList();
                    build.addJmpUnless(l1);
                    build.addPop();
                    build.addPop();
                    SyntaxUtils.compileList(d2.getCdr(), env, comp, build, callsym, istail, mesg, symlist, exec, memento, syncased);
                    build.addJmp(last);
                    build.setCurrentAddressToLabel(l1);
                    build.addPop();
                }
                d = ((Cons)d).getCdr();
            }
            throw mesg.getError("err.case.improper");
        }
    }

    @Override
    Datum replaceLocalVals(Datum body, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, boolean toplv, int ttype) {
        Datum d = body;
        ArrayList<Datum> lst = new ArrayList<Datum>();
        if (d instanceof Cons) {
            Cons c0 = (Cons)d;
            lst.add(comp.replaceLocalVals(c0.getCar(), env, ienv, false, ttype));
            d = c0.getCdr();
        } else {
            throw mesg.getError("err.case.malform");
        }
        while (d != Nil.NIL) {
            if (d instanceof Cons) {
                Cons rc;
                Datum d1 = ((Cons)d).getCar();
                if (!(d1 instanceof Cons)) {
                    throw mesg.getError("err.case.malform", d1);
                }
                Cons d2 = (Cons)d1;
                if (this.isElseScope(d2.getCar())) {
                    rc = new Cons();
                    rc.setCar(ELSE_SYM);
                    rc.setCdr(SyntaxUtils.replaceLocalValsList(d2.getCdr(), env, comp, ienv, mesg, toplv, ttype));
                    lst.add(rc);
                    break;
                }
                rc = new Cons();
                List<Datum> keys = LispUtils.consToList(d2.getCar(), mesg);
                ArrayList<Datum> k2 = new ArrayList<Datum>();
                int i = 0;
                while (i < keys.size()) {
                    k2.add(comp.replaceLocalVals(keys.get(i), env, ienv, false, ttype));
                    ++i;
                }
                rc.setCar(LispUtils.listToCons(k2));
                rc.setCdr(SyntaxUtils.replaceLocalValsList(d2.getCdr(), env, comp, ienv, mesg, toplv, ttype));
                lst.add(rc);
                d = ((Cons)d).getCdr();
                continue;
            }
            throw mesg.getError("err.case.improper");
        }
        return LispUtils.listToCons(lst);
    }
}

