/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.ArrayList;
import java.util.List;
import net.morilib.lisp.ClosureClass;
import net.morilib.lisp.CodeExecutor;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.IntStack;
import net.morilib.lisp.LispCompiler;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.SymbolName;
import net.morilib.lisp.SynLetType;
import net.morilib.lisp.Syntax;
import net.morilib.lisp.SyntaxUtils;
import net.morilib.lisp.Undef;

public class SynLetrec
extends Syntax
implements SynLetType {
    @Override
    void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento, LispCompiler.MiscInfo syncased) {
        Environment nenv;
        Datum bcdr;
        CompiledCode.Builder nbuild;
        if (body instanceof Cons) {
            nbuild = new CompiledCode.Builder();
            Datum bcar = ((Cons)body).getCar();
            bcdr = ((Cons)body).getCdr();
            nenv = new Environment(env);
            if (bcar instanceof Cons) {
                Datum d = bcar;
                while (d != Nil.NIL) {
                    if (d instanceof Cons) {
                        Datum d3c;
                        Cons d3;
                        Datum d2 = ((Cons)d).getCar();
                        if (d2 instanceof Cons) {
                            d3 = (Cons)d2;
                            d3c = d3.getCar();
                            if (!(d3c instanceof SymbolName)) {
                                throw mesg.getError("err.letrec.malform");
                            }
                        } else {
                            throw mesg.getError("err.letrec.malform");
                        }
                        SyntaxUtils.compileBind(d3c, d3.getCdr(), env, comp, nbuild, new Cons(), false, mesg, "err.letrec.malform", new ArrayList<Cons>(), exec, memento, syncased);
                        nbuild.addPop();
                        nenv.bindDatumWithoutScope(d3c, Undef.UNDEF2);
                        d = ((Cons)d).getCdr();
                        continue;
                    }
                    throw mesg.getError("err.letrec.malform");
                }
            } else if (bcar != Nil.NIL) {
                throw mesg.getError("err.letrec.malform");
            }
        } else {
            throw mesg.getError("err.letrec.malform");
        }
        symlist.add(callsym);
        SyntaxUtils.compileList(bcdr, nenv, comp, nbuild, new Cons(), istail, mesg, symlist, exec, memento, syncased);
        symlist.remove(0);
        nbuild.addReturnOp();
        ClosureClass cl = new ClosureClass(Nil.NIL, nbuild.getCodeRef());
        build.addPush(cl);
        build.addBeginList();
        build.addEndList();
        build.addCall();
    }

    @Override
    Datum replaceLocalVals(Datum body, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, boolean toplv, int ttype) {
        if (body instanceof Cons) {
            Datum bcar = ((Cons)body).getCar();
            Datum bcdr = ((Cons)body).getCdr();
            ArrayList<Datum> lst = new ArrayList<Datum>();
            Environment nenv = new Environment(ienv);
            ArrayList<Datum> lst2 = new ArrayList<Datum>();
            if (bcar instanceof Cons) {
                Datum d = bcar;
                while (d != Nil.NIL) {
                    if (d instanceof Cons) {
                        Cons rc = new Cons();
                        Cons r2 = new Cons();
                        rc.setCdr(r2);
                        List<Datum> l2 = LispUtils.consToList(((Cons)d).getCar(), mesg);
                        if (l2.size() != 2) {
                            throw mesg.getError("err.letrec.malform");
                        }
                        rc.setCar(SyntaxUtils.putSymbol(nenv, l2.get(0), mesg));
                        r2.setCar(comp.replaceLocalVals(l2.get(1), env, nenv, false, ttype));
                        d = ((Cons)d).getCdr();
                        lst2.add(rc);
                        continue;
                    }
                    throw mesg.getError("err.letrec.malform");
                }
            } else if (bcar != Nil.NIL) {
                throw mesg.getError("err.letrec.malform");
            }
            lst.add(LispUtils.listToCons(lst2));
            Datum cdrx = SyntaxUtils.replaceLocalValsList(bcdr, env, comp, nenv, mesg, ttype);
            return LispUtils.listToCons(lst, cdrx);
        }
        throw mesg.getError("err.letrec.malform");
    }
}

