/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.morilib.lisp.ClosureClass;
import net.morilib.lisp.CodeExecutor;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.IntStack;
import net.morilib.lisp.LispCompiler;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.SynImport;
import net.morilib.lisp.Syntax;
import net.morilib.lisp.SyntaxUtils;
import net.morilib.lisp.r6rs.LibraryID;
import net.morilib.lisp.r6rs.LibraryIDException;
import net.morilib.lisp.r6rs.SymbolEnv;

public class SynLibrary
extends Syntax {
    private static final Symbol EXPORT = Symbol.getSymbol("export");
    private static final Symbol RENAME = Symbol.getSymbol("rename");
    private static final Symbol IMPORT = Symbol.getSymbol("import");

    private void torens(Datum d, Map<Symbol, Symbol> sym, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(d);
        while (itr.hasNext()) {
            Datum o = itr.next();
            if (o instanceof Cons) {
                Cons c1 = (Cons)o;
                if (!(c1.getCdr() instanceof Cons)) {
                    throw mesg.getError("err.library.malform");
                }
                Cons c2 = (Cons)c1.getCdr();
                if (c2.getCdr() != Nil.NIL) {
                    throw mesg.getError("err.library.malform");
                }
                if (!(c1.getCar() instanceof Symbol)) {
                    throw mesg.getError("err.require.symbol", c1.getCar());
                }
                if (!(c2.getCar() instanceof Symbol)) {
                    throw mesg.getError("err.require.symbol", c2.getCar());
                }
                sym.put((Symbol)c1.getCar(), (Symbol)c2.getCar());
                continue;
            }
            throw mesg.getError("err.library.malform");
        }
        if (itr.getTerminal() != Nil.NIL) {
            throw mesg.getError("err.list.symbol");
        }
    }

    private Map<Symbol, Symbol> tosyms(Datum d, LispMessage mesg, Map<Symbol, SymbolEnv> mp) {
        ConsIterator itr = new ConsIterator(d);
        HashMap<Symbol, Symbol> res = new HashMap<Symbol, Symbol>();
        while (itr.hasNext()) {
            Datum o = itr.next();
            if (o instanceof Symbol) {
                res.put((Symbol)o, (Symbol)o);
                continue;
            }
            if (o instanceof Cons) {
                Cons c1 = (Cons)o;
                if (!c1.getCar().equals(RENAME)) {
                    throw mesg.getError("err.list.symbol");
                }
                this.torens(c1.getCdr(), res, mesg);
                continue;
            }
            throw mesg.getError("err.list.symbol");
        }
        if (itr.getTerminal() != Nil.NIL) {
            throw mesg.getError("err.list.symbol");
        }
        for (SymbolEnv e : mp.values()) {
            res.put(e.getSymbol(), e.getSymbol());
        }
        return res;
    }

    @Override
    void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento, LispCompiler.MiscInfo syncased) {
        Cons c20;
        Cons c2;
        Datum c2i = null;
        HashMap<Symbol, SymbolEnv> mp = new HashMap();
        if (!toplevel) {
            throw mesg.getError("err.nottoplevel");
        }
        if (!(body instanceof Cons)) {
            throw mesg.getError("err.library.malform");
        }
        Cons c0 = (Cons)body;
        if (!(c0.getCar() instanceof Cons)) {
            throw mesg.getError("err.libid");
        }
        Cons c00 = (Cons)c0.getCar();
        if (!(c0.getCdr() instanceof Cons)) {
            throw mesg.getError("err.library.malform");
        }
        Cons c1 = (Cons)c0.getCdr();
        if (!(c1.getCar() instanceof Cons)) {
            throw mesg.getError("err.library.malform");
        }
        Cons c10 = (Cons)c1.getCar();
        if (!c10.getCar().equals(EXPORT)) {
            throw mesg.getError("err.library.malform");
        }
        if (c1.getCdr() instanceof Cons && (c2 = (Cons)c1.getCdr()).getCar() instanceof Cons && (c20 = (Cons)c2.getCar()).getCar().equals(IMPORT)) {
            c2i = c20.getCdr();
            c1 = c2;
        }
        if (!(c00.getCar() instanceof Symbol)) {
            throw mesg.getError("err.libid");
        }
        LibraryID libid = new LibraryID(c00);
        CompiledCode.Builder nbuild = new CompiledCode.Builder();
        Environment nenv = new Environment(env);
        if (c2i != null) {
            try {
                mp = LibraryID.compileImport(c2i);
            }
            catch (LibraryIDException e) {
                throw e.toLispException(mesg);
            }
            SynImport.buildImport(mp, nbuild, mesg);
        }
        SyntaxUtils.compileList(c1.getCdr(), nenv, comp, nbuild, callsym, false, mesg, symlist, exec, memento, toplevel, syncased);
        nbuild.addSetLibID(libid, this.tosyms(c10.getCdr(), mesg, mp));
        nbuild.addReturnOp();
        ClosureClass cln = new ClosureClass(Nil.NIL, nbuild.getCodeRef());
        build.addPush(cln);
        build.addBeginList();
        build.addEndList();
        build.addCall();
    }

    @Override
    Datum replaceLocalVals(Datum body, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, boolean toplv, int ttype) {
        throw mesg.getError("err.library.definesyntax");
    }
}

