/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.List;
import java.util.Set;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.ExecuteEnvScope;
import net.morilib.lisp.Symbol;

final class UserSyntax
extends Datum
implements ExecuteEnvScope {
    private String name;
    private List<Datum> patternList;
    private List<Datum> templateList;
    private List<Set<Symbol>> paramList;
    private Set<Symbol> reservedSet;
    private Environment compileEnv;
    private boolean definedLetSyntax;
    private CompiledCode lambda;
    private UserSyntax rootsyn;
    private Environment executeEnv = null;

    UserSyntax(String name, List<Datum> patlist, List<Datum> tmplist, List<Set<Symbol>> paramList, Set<Symbol> reserved, Environment compileEnv, boolean definedLetSyntax) {
        if (name == null || patlist == null || tmplist == null || reserved == null || compileEnv == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.patternList = patlist;
        this.templateList = tmplist;
        this.paramList = paramList;
        this.reservedSet = reserved;
        this.compileEnv = compileEnv;
        this.definedLetSyntax = definedLetSyntax;
        this.lambda = null;
    }

    UserSyntax(String name, List<Datum> patlist, List<Datum> tmplist, List<Set<Symbol>> paramList, Set<Symbol> reserved, Environment compileEnv, UserSyntax rootsyn) {
        if (name == null || patlist == null || tmplist == null || reserved == null || compileEnv == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.patternList = patlist;
        this.templateList = tmplist;
        this.paramList = paramList;
        this.reservedSet = reserved;
        this.compileEnv = compileEnv;
        this.rootsyn = rootsyn;
        this.lambda = null;
    }

    UserSyntax(String name, Environment compileEnv, CompiledCode lambda) {
        if (name == null || lambda == null || compileEnv == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.lambda = lambda;
        this.compileEnv = compileEnv;
    }

    public List<Datum> getPatternList() {
        return this.patternList;
    }

    public List<Datum> getTemplateList() {
        return this.templateList;
    }

    public Set<Symbol> getReservedSet() {
        return this.reservedSet;
    }

    public String getName() {
        UserSyntax s2 = this;
        while (s2.getRootSyntax() != null) {
            s2 = s2.getRootSyntax();
        }
        return s2.name;
    }

    public List<Set<Symbol>> getParamList() {
        return this.paramList;
    }

    public Environment getCompileEnv() {
        return this.compileEnv;
    }

    public boolean isDefinedLetSyntax() {
        return this.definedLetSyntax;
    }

    @Override
    public Environment getExecuteEnv() {
        return this.executeEnv;
    }

    void setExecuteEnv(Environment executeEnv) {
        this.executeEnv = executeEnv;
    }

    CompiledCode getLambda() {
        return this.lambda;
    }

    UserSyntax getRootSyntax() {
        return this.rootsyn;
    }
}

