/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.painter;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispIOException;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Undef;
import net.morilib.lisp.painter.SchlushPainterFrame;

public class WriteImageFile
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        String imgf;
        List<Datum> l = LispUtils.consToList(body, mesg);
        if (l.size() == 2) {
            if (!(l.get(0) instanceof SchlushPainterFrame)) {
                throw mesg.getError("err.require.painterframe", l.get(0));
            }
            LispUtils.checkString(l.get(1), mesg);
        } else if (l.size() == 3) {
            if (!(l.get(0) instanceof SchlushPainterFrame)) {
                throw mesg.getError("err.require.painterframe", l.get(0));
            }
            LispUtils.checkString(l.get(1), mesg);
            LispUtils.checkSymbol(l.get(2), mesg);
        }
        String fname = ((LispString)l.get(1)).getString();
        if (l.size() == 3) {
            imgf = ((Symbol)l.get(2)).getName();
        } else {
            int ind = fname.lastIndexOf(46);
            if (ind < 0) {
                throw mesg.getError("err.invaild.formatname", "");
            }
            imgf = fname.substring(ind + 1);
        }
        try {
            boolean r = ImageIO.write((RenderedImage)((SchlushPainterFrame)l.get((int)0)).image, imgf, new File(fname));
            if (!r) {
                throw mesg.getError("err.invalid.formatname", imgf);
            }
        }
        catch (IOException e) {
            throw new LispIOException(e);
        }
        return Undef.UNDEF;
    }
}

