/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.sql;

import java.sql.SQLException;
import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.sql.LispJdbcConnection;
import net.morilib.lisp.sql.LispSQLException;

public class JdbcConnect
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> l = LispUtils.consToList(body, mesg);
        if (l.size() == 1) {
            if (!(l.get(0) instanceof LispString)) {
                throw mesg.getError("err.require.string", l.get(0));
            }
            try {
                return new LispJdbcConnection(l.get(0).getString());
            }
            catch (SQLException e) {
                throw LispSQLException.getError(mesg, e);
            }
        }
        if (l.size() == 3) {
            if (!(l.get(0) instanceof LispString)) {
                throw mesg.getError("err.require.string", l.get(0));
            }
            if (!(l.get(1) instanceof LispString)) {
                throw mesg.getError("err.require.string", l.get(1));
            }
            if (!(l.get(2) instanceof LispString)) {
                throw mesg.getError("err.require.string", l.get(2));
            }
            try {
                return new LispJdbcConnection(l.get(0).getString(), l.get(1).getString(), l.get(2).getString());
            }
            catch (SQLException e) {
                throw LispSQLException.getError(mesg, e);
            }
        }
        throw mesg.getError("err.argument", body);
    }
}

