/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.special;

import net.morilib.lang.number.complex.ComplexDouble;
import net.morilib.lang.number.complex.ComplexDoubleTransform;
import net.morilib.lang.number.complex.ComplexMath;
import net.morilib.lang.number.complex.RectanglarComplexDouble;
import net.morilib.lang.number.complex.RectanglarComplexDoubleRegister;
import net.morilib.lang.transform.DoubleTransform;
import net.morilib.math.Math2;
import net.morilib.math.special.ZetaFunctions;

public class GammaFunctions {
    public static final DoubleTransform GAMMA = new _G();
    public static final ComplexDoubleTransform GAMMAC = new _GC();

    static double byInfiniteProduct(double x) {
        double r = 1.0;
        double rold = Double.MAX_VALUE;
        double w = x - 1.0;
        int p = 1;
        while (Math.abs(r - rold) / Math.abs(r + rold) > 1.0E-14) {
            rold = r;
            r *= (1.0 + w / (double)p) * Math.exp(-w / (double)p);
            if (p++ >= 100) break;
        }
        return 1.0 / r / Math.exp(0.5772156649015329 * w);
    }

    static double logGamma(double x) {
        double r = 0.0;
        double rold = Double.MAX_VALUE;
        double w = x - 1.0;
        int n = 2;
        while (Math.abs(r - rold) > 1.0E-14) {
            rold = r;
            r += ZetaFunctions.RIEMANN_ZETA_SEQUENCE.f(n) / (double)n * Math.pow(w, n) * (double)((n & 1) == 0 ? 1 : -1);
            ++n;
        }
        return r - 0.5772156649015329 * w;
    }

    static double logGamma2(double x) {
        double r = 0.0;
        double rold = Double.MAX_VALUE;
        double w = x - 2.0;
        int n = 2;
        while (Math.abs(r - rold) > Double.MIN_VALUE) {
            rold = r;
            r += (ZetaFunctions.RIEMANN_ZETA_SEQUENCE.f(n) - 1.0) / (double)n * Math.pow(w, n) * (double)((n & 1) == 0 ? 1 : -1);
            ++n;
        }
        return r + 0.42278433509846713 * w;
    }

    static ComplexDouble logGamma(ComplexDouble z) {
        ComplexDouble w = z.subtract(1.0);
        ComplexDouble rold = ComplexDouble.REAL_POSITIVE_INFINITY;
        int n = 2;
        RectanglarComplexDoubleRegister r = new RectanglarComplexDoubleRegister(0.0, 0.0);
        RectanglarComplexDoubleRegister w2 = new RectanglarComplexDoubleRegister(w);
        while (rold.subtract(r.toComplex()).abs() > 1.0E-14) {
            double zetan = ZetaFunctions.RIEMANN_ZETA_SEQUENCE.f(n);
            rold = r.toComplex();
            w2.multiply(w);
            if ((n & 1) == 0) {
                r.add(w2.toComplex().multiply(zetan / (double)n));
            } else {
                r.subtract(w2.toComplex().multiply(zetan / (double)n));
            }
            ++n;
        }
        return r.subtract(w.multiply(0.5772156649015329)).toComplex();
    }

    static ComplexDouble logGamma2(ComplexDouble z) {
        ComplexDouble w = z.subtract(2.0);
        ComplexDouble rold = ComplexDouble.REAL_POSITIVE_INFINITY;
        int n = 2;
        RectanglarComplexDoubleRegister r = new RectanglarComplexDoubleRegister(0.0, 0.0);
        RectanglarComplexDoubleRegister w2 = new RectanglarComplexDoubleRegister(w);
        while (rold.subtract(r.toComplex()).abs() > 1.0E-14) {
            double zetan = ZetaFunctions.RIEMANN_ZETA_SEQUENCE.f(n);
            rold = r.toComplex();
            w2.multiply(w);
            if ((n & 1) == 0) {
                r.add(w2.toComplex().multiply((zetan - 1.0) / (double)n));
            } else {
                r.subtract(w2.toComplex().multiply((zetan - 1.0) / (double)n));
            }
            ++n;
        }
        return r.add(w.multiply(0.42278433509846713)).toComplex();
    }

    static double byAsymptoticExpansion(double x) {
        double r = 0.0;
        double w = x - 1.0;
        r = 1.0;
        r += 0.08333333333333333 / w;
        r += 0.003472222222222222 / w / w;
        return (r += 0.0026813271604938273 / w / w / w) * Math.exp(-w + w * Math.log(w)) * Math.sqrt(Math.PI * 2 * w);
    }

    static ComplexDouble byAsymptoticExpansion(ComplexDouble z) {
        ComplexDouble w = z.add(-1.0);
        RectanglarComplexDoubleRegister r = new RectanglarComplexDoubleRegister(1.0, 0.0);
        r.add(((ComplexDouble)w.power(-1)).multiply(0.08333333333333333));
        r.add(((ComplexDouble)w.power(-2)).multiply(0.003472222222222222));
        r.add(((ComplexDouble)w.power(-3)).multiply(0.0026813271604938273));
        r.multiply(ComplexMath.exp(w.multiply(ComplexMath.log(w)).subtract(w)));
        r.multiply(ComplexMath.sqrt(w.multiply(Math.PI * 2)));
        return r.toComplex();
    }

    static double gammaBetween01(double x) {
        if (x <= 0.001) {
            return Math.PI / Math.exp(GammaFunctions.logGamma(1.0 - x)) / Math.sin(Math.PI * x);
        }
        if (x == 1.0 || x == 2.0) {
            return 1.0;
        }
        if (x <= 0.5) {
            return Math.exp(GammaFunctions.logGamma(x));
        }
        return Math.PI / Math.exp(GammaFunctions.logGamma(1.0 - x)) / Math.sin(Math.PI * x);
    }

    static double byIntegral(double x) {
        double h = 0.001;
        double r = 0.0;
        int n = 0;
        r = 0.0;
        while ((double)n * h < 10.0) {
            double t0 = h * (double)n;
            double t1 = h * (double)(n + 1);
            r += 4.0 * Math.exp(-t0) * Math.pow(t0, x - 1.0) * h / 3.0;
            r += 2.0 * Math.exp(-t1) * Math.pow(t1, x - 1.0) * h / 3.0;
            n += 2;
        }
        return r += Math.exp(-h * (double)n) * Math.pow(h * (double)n, x - 1.0) * h / 3.0;
    }

    public static double gamma(double x) {
        return GAMMA.f(x);
    }

    public static ComplexDouble gamma(ComplexDouble z) {
        return GAMMAC.f(z);
    }

    static class _G
    implements DoubleTransform {
        _G() {
        }

        @Override
        public double f(double x) {
            if (x < 0.0) {
                double n = Math.floor(x);
                double w = Math.IEEEremainder(x, 1.0);
                if (w == 0.0) {
                    return Double.NaN;
                }
                if (w < 0.0) {
                    w += 1.0;
                }
                double r = this.f(w);
                int i = -1;
                while ((double)i >= n - 1.0E-4) {
                    r /= (double)i + w;
                    --i;
                }
                return r;
            }
            if (x == 0.0) {
                return Double.NaN;
            }
            if (x <= 0.5) {
                return Math.PI / Math.exp(GammaFunctions.logGamma(1.0 - x)) / Math.sin(Math.PI * x);
            }
            if (x == 1.0) {
                return 1.0;
            }
            if (x < 1.5) {
                return Math.exp(GammaFunctions.logGamma2(x + 1.0)) / x;
            }
            if (x <= 2.5) {
                return Math.exp(GammaFunctions.logGamma2(x));
            }
            if (x <= 30.0) {
                double r;
                int n = (int)Math.floor(x);
                double w = Math.IEEEremainder(x, 1.0);
                if (w == 0.0) {
                    r = 1.0;
                    int i = 1;
                    while (i < n) {
                        r *= (double)i;
                        ++i;
                    }
                } else {
                    if (w < 0.0) {
                        w += 1.0;
                    }
                    r = Math.exp(GammaFunctions.logGamma2(w + 1.0));
                    int i = 1;
                    while (i < n) {
                        r *= (double)i + w;
                        ++i;
                    }
                }
                return r;
            }
            return GammaFunctions.byAsymptoticExpansion(x);
        }
    }

    static class _GC
    implements ComplexDoubleTransform {
        _GC() {
        }

        @Override
        public ComplexDouble f(ComplexDouble z) {
            if (z.isReal()) {
                return RectanglarComplexDouble.realValueOf(GAMMA.f(z.realPart()));
            }
            if (z.realPart() < 0.0) {
                double x = z.realPart();
                double n = Math.floor(x);
                double rm = Math2.decimalPart(z.realPart());
                ComplexDouble w = RectanglarComplexDouble.valueOf(rm, z.imagPart());
                RectanglarComplexDoubleRegister r = new RectanglarComplexDoubleRegister(this.f(w));
                int i = -1;
                while ((double)i >= n - 1.0E-4) {
                    r.divide(w.add(i));
                    --i;
                }
                return r.toComplex();
            }
            if (z.isZero()) {
                return ComplexDouble.NaN;
            }
            if (z.abs() <= 0.5) {
                RectanglarComplexDoubleRegister rg = new RectanglarComplexDoubleRegister(Math.PI, 0.0);
                rg.divide(ComplexMath.exp(GammaFunctions.logGamma((ComplexDouble)z.subtract(1.0).negate())));
                rg.divide(ComplexMath.sin(z.multiply(Math.PI)));
                return rg.toComplex();
            }
            if (z.isUnit()) {
                return RectanglarComplexDouble.realValueOf(1.0);
            }
            if (z.abs() < 1.5) {
                return ComplexMath.exp(GammaFunctions.logGamma2(z.add(1.0))).divide(z);
            }
            if (z.abs() <= 2.5) {
                return ComplexMath.exp(GammaFunctions.logGamma2(z));
            }
            if (z.realPart() > 2.5 && z.realPart() <= 30.0) {
                int n = (int)Math.floor(z.realPart());
                double rm = Math2.decimalPart(z.realPart());
                ComplexDouble w = RectanglarComplexDouble.valueOf(rm, z.imagPart());
                RectanglarComplexDoubleRegister r = new RectanglarComplexDoubleRegister(this.f(w.add(1.0)));
                int i = 1;
                while (i < n) {
                    r.multiply(w.add(i));
                    ++i;
                }
                return r.toComplex();
            }
            if (z.abs() <= 30.0) {
                return ComplexMath.exp(GammaFunctions.logGamma2(z));
            }
            return GammaFunctions.byAsymptoticExpansion(z);
        }
    }
}

