/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public final class Maps {
    public static final SortedMap<Object, Object> EMPTY = new SortedMap<Object, Object>(){

        @Override
        public Object firstKey() {
            throw new NoSuchElementException();
        }

        @Override
        public Object lastKey() {
            throw new NoSuchElementException();
        }

        @Override
        public Comparator<Object> comparator() {
            return null;
        }

        @Override
        public SortedMap<Object, Object> headMap(Object toKey) {
            return this;
        }

        @Override
        public SortedMap<Object, Object> tailMap(Object fromKey) {
            return this;
        }

        @Override
        public SortedMap<Object, Object> subMap(Object fromKey, Object toKey) {
            return this;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public Collection<Object> values() {
            return Collections.EMPTY_SET;
        }

        @Override
        public void putAll(Map<?, ?> t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return Collections.EMPTY_SET;
        }

        @Override
        public Set<Object> keySet() {
            return Collections.EMPTY_SET;
        }

        @Override
        public Object get(Object key) {
            return null;
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof SortedMap) {
                return ((Map)o).isEmpty();
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "[]";
        }
    };

    private Maps() {
    }

    public static <K, V> Map<K, V> emptySortedMap() {
        return EMPTY;
    }

    public static <K, V> Map<K, V> init(Map<K, V> map, Object[][] data) {
        int i = 0;
        while (i < data.length) {
            if (data[i].length < 2) {
                throw new IllegalArgumentException("too few");
            }
            map.put(data[i][0], data[i][1]);
            ++i;
        }
        return map;
    }

    public static <K, V> Map<K, V> initHashMap(Object[][] data) {
        return Maps.init(new HashMap(), data);
    }

    public static <T> Map<T, T> identityMapOf(Set<T> set) {
        final Set<T> s = set;
        final AbstractSet t = new AbstractSet<Map.Entry<T, T>>(){

            @Override
            public Iterator<Map.Entry<T, T>> iterator() {
                final Iterator itr = s.iterator();
                return new Iterator<Map.Entry<T, T>>(){

                    @Override
                    public boolean hasNext() {
                        return itr.hasNext();
                    }

                    @Override
                    public Map.Entry<T, T> next() {
                        final Object n = itr.next();
                        return new Map.Entry<T, T>(){

                            @Override
                            public T getKey() {
                                return n;
                            }

                            @Override
                            public T getValue() {
                                return n;
                            }

                            @Override
                            public T setValue(T value) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        itr.remove();
                    }
                };
            }

            @Override
            public int size() {
                return s.size();
            }

            @Override
            public boolean contains(Object o) {
                return s.contains(o);
            }

            @Override
            public boolean add(Map.Entry<T, T> e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<T, T>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                s.clear();
            }
        };
        return new AbstractMap<T, T>(){

            @Override
            public Set<Map.Entry<T, T>> entrySet() {
                return t;
            }

            @Override
            public int size() {
                return s.size();
            }

            @Override
            public boolean isEmpty() {
                return s.isEmpty();
            }

            @Override
            public boolean containsValue(Object value) {
                return s.contains(value);
            }

            @Override
            public boolean containsKey(Object key) {
                return s.contains(key);
            }

            @Override
            public T get(Object key) {
                return s.contains(key) ? key : null;
            }

            @Override
            public T put(T key, T value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public T remove(Object key) {
                return s.remove(key) ? key : null;
            }

            @Override
            public void putAll(Map<? extends T, ? extends T> m) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                s.clear();
            }

            @Override
            public Set<T> keySet() {
                return s;
            }

            @Override
            public Collection<T> values() {
                return s;
            }
        };
    }

    private static <K, V> Map<K, V> _map(Transform<V> cnt, Map<K, V> dest, boolean removeIfNull, Map<K, V> src) {
        for (Map.Entry<K, V> e : src.entrySet()) {
            V r = cnt.transform(e.getValue());
            if (r == null && removeIfNull) continue;
            dest.put(e.getKey(), r);
        }
        return dest;
    }

    private static <K, V> Map<K, V> _mapEntry(TransformEntry<K, V> cnt, Map<K, V> dest, boolean removeIfNull, Map<K, V> src) {
        for (Map.Entry<K, V> e : src.entrySet()) {
            V r = cnt.transform(e.getKey(), e.getValue());
            if (r == null && removeIfNull) continue;
            dest.put(e.getKey(), r);
        }
        return dest;
    }

    private static <K, V> Map<K, V> _map(Transform2<V> cnt, Map<K, V> dest, boolean removeIfNull, Map<K, V> src1, Map<K, V> src2) {
        HashSet<K> keys = new HashSet<K>();
        keys.addAll(src1.keySet());
        keys.addAll(src2.keySet());
        for (Object k : keys) {
            Object r = null;
            r = cnt.transform(src1.get(k), src2.get(k));
            if (r == null && removeIfNull) continue;
            dest.put(k, r);
        }
        return dest;
    }

    public static <K, V> Map<K, V> map(Transform<V> cnt, Map<K, V> dest, Map<K, V> src) {
        return Maps._map(cnt, dest, false, src);
    }

    public static <K, V> Map<K, V> map(Transform2<V> cnt, Map<K, V> dest, Map<K, V> src1, Map<K, V> src2) {
        return Maps._map(cnt, dest, false, src1, src2);
    }

    public static <K, V> Map<K, V> mapEntry(TransformEntry<K, V> cnt, Map<K, V> dest, Map<K, V> src) {
        return Maps._mapEntry(cnt, dest, false, src);
    }

    public static <K, V> Map<K, V> mapRemoveIfNull(Transform<V> cnt, Map<K, V> dest, Map<K, V> src) {
        return Maps._map(cnt, dest, true, src);
    }

    public static <K, V> Map<K, V> mapRemoveIfNull(Transform2<V> cnt, Map<K, V> dest, Map<K, V> src1, Map<K, V> src2) {
        return Maps._map(cnt, dest, true, src1, src2);
    }

    public static <K, V> Map<K, V> mapEntryRemoveIfNull(TransformEntry<K, V> cnt, Map<K, V> dest, Map<K, V> src) {
        return Maps._mapEntry(cnt, dest, true, src);
    }

    public static <K, V> void each(Each<V> cnt, Map<K, V> src) {
        for (Map.Entry<K, V> e : src.entrySet()) {
            cnt.each(e.getValue());
        }
    }

    public static <K, V> void each(Each2<V> cnt, Map<K, V> src1, Map<K, V> src2) {
        HashSet<K> keys = new HashSet<K>();
        keys.addAll(src1.keySet());
        keys.addAll(src2.keySet());
        for (Object k : keys) {
            cnt.each(src1.get(k), src2.get(k));
        }
    }

    public static <K, V> void eachEntry(EachEntry<K, V> cnt, Map<K, V> src) {
        for (Map.Entry<K, V> e : src.entrySet()) {
            cnt.each(e.getKey(), e.getValue());
        }
    }

    public static interface Each<V> {
        public void each(V var1);
    }

    public static interface Each2<V> {
        public void each(V var1, V var2);
    }

    public static interface EachEntry<K, V> {
        public void each(K var1, V var2);
    }

    public static interface Transform<V> {
        public V transform(V var1);
    }

    public static interface Transform2<V> {
        public V transform(V var1, V var2);
    }

    public static interface TransformEntry<K, V> {
        public V transform(K var1, V var2);
    }
}

