/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.io.Serializable;
import java.util.Collection;
import java.util.RandomAccess;
import net.morilib.lang.Hashes;
import net.morilib.util.primitive.AbstractByteVector;
import net.morilib.util.primitive.ByteCollection;

public class ByteArrayVector
extends AbstractByteVector
implements RandomAccess,
Serializable {
    private static final long serialVersionUID = 3332872309405682099L;
    private byte[] array;
    private transient int size;

    public ByteArrayVector(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException();
        }
        this.array = new byte[initialCapacity];
    }

    public ByteArrayVector() {
        this(10);
    }

    public ByteArrayVector(ByteCollection a) {
        this.array = a.toByteArray();
        this.size = this.array.length;
    }

    public ByteArrayVector(ByteCollection ... as) {
        this.size = 0;
        ByteCollection[] byteCollectionArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            ByteCollection a = byteCollectionArray[n2];
            this.size += a.size();
            ++n2;
        }
        int s2 = 0;
        this.array = new byte[this.size];
        ByteCollection[] byteCollectionArray2 = as;
        int n3 = as.length;
        n = 0;
        while (n < n3) {
            ByteCollection a = byteCollectionArray2[n];
            byte[] b = a.toByteArray();
            System.arraycopy(b, 0, this.array, s2, b.length);
            s2 += a.size();
            ++n;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ByteArrayVector(Collection<? extends ByteCollection> as) {
        this.size = 0;
        for (ByteCollection byteCollection : as) {
            this.size += byteCollection.size();
        }
        boolean bl = false;
        this.array = new byte[this.size];
        for (ByteCollection byteCollection : as) {
            void var2_7;
            byte[] b = byteCollection.toByteArray();
            System.arraycopy(b, 0, this.array, (int)var2_7, b.length);
            var2_7 += byteCollection.size();
        }
    }

    public void ensureCapacity(int nsize) {
        if (nsize > this.array.length) {
            int ns = nsize;
            while (ns < this.array.length) {
                int n = ns = this.array.length < 0x4CCCCCCA ? this.array.length / 3 * 5 + 1 : Integer.MAX_VALUE;
            }
            byte[] b = new byte[ns];
            System.arraycopy(this.array, 0, b, 0, this.size);
            this.array = b;
        }
    }

    @Override
    public void addByte(int index, byte v) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.size + 1);
        ++this.modCount;
        if (index < this.size) {
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        }
        this.array[index] = v;
        ++this.size;
    }

    @Override
    public boolean addAllByte(int index, ByteCollection a) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
        if (a.isEmpty()) {
            return false;
        }
        byte[] b = a.toByteArray();
        this.ensureCapacity(this.size + b.length);
        System.arraycopy(this.array, index, this.array, index + b.length, this.size - index);
        System.arraycopy(b, 0, this.array, index, b.length);
        this.size += b.length;
        return true;
    }

    @Override
    public byte getByte(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[index];
    }

    @Override
    public byte removeAt(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        byte res = this.array[index];
        ++this.modCount;
        if (index < this.size - 1) {
            System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
        }
        --this.size;
        return res;
    }

    @Override
    public byte setByte(int index, byte v) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        byte res = this.array[index];
        ++this.modCount;
        this.array[index] = v;
        return res;
    }

    @Override
    public boolean addAllByte(ByteCollection a) {
        byte[] b = a.toByteArray();
        ++this.modCount;
        this.ensureCapacity(this.size + b.length);
        System.arraycopy(b, 0, this.array, this.size, b.length);
        this.size += b.length;
        return true;
    }

    @Override
    public boolean addAllByte(ByteCollection ... as) {
        int nsize = 0;
        ByteCollection[] byteCollectionArray = as;
        int n = as.length;
        int n2 = 0;
        while (n2 < n) {
            ByteCollection a = byteCollectionArray[n2];
            nsize += a.size();
            ++n2;
        }
        if (nsize > 0) {
            int s2 = this.size;
            ++this.modCount;
            this.ensureCapacity(this.size + nsize);
            ByteCollection[] byteCollectionArray2 = as;
            int n3 = as.length;
            n = 0;
            while (n < n3) {
                ByteCollection a = byteCollectionArray2[n];
                byte[] b = a.toByteArray();
                System.arraycopy(b, 0, this.array, s2, b.length);
                s2 += a.size();
                ++n;
            }
            this.size += nsize;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAllByte(Collection<? extends ByteCollection> as) {
        int nsize = 0;
        for (ByteCollection byteCollection : as) {
            nsize += byteCollection.size();
        }
        if (nsize > 0) {
            int n = this.size;
            ++this.modCount;
            this.ensureCapacity(this.size + nsize);
            for (ByteCollection byteCollection : as) {
                void var3_8;
                byte[] b = byteCollection.toByteArray();
                System.arraycopy(b, 0, this.array, (int)var3_8, b.length);
                var3_8 += byteCollection.size();
            }
            this.size += nsize;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public byte[] toByteArray() {
        byte[] b = new byte[this.size];
        System.arraycopy(this.array, 0, b, 0, this.size);
        return b;
    }

    @Override
    public byte[] toByteArray(byte[] a) {
        if (a.length < this.size) {
            return this.toByteArray();
        }
        System.arraycopy(this.array, 0, a, 0, this.size);
        return a;
    }

    @Override
    public int hashCode() {
        return Hashes.sumHashCode(this.array);
    }
}

