/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import net.morilib.util.primitive.AbstractByteSet;
import net.morilib.util.primitive.BitSet2;
import net.morilib.util.primitive.BitSet2Class;
import net.morilib.util.primitive.ByteCollection;
import net.morilib.util.primitive.ByteCollections;
import net.morilib.util.primitive.ByteSet;
import net.morilib.util.primitive.ByteSortedSet;
import net.morilib.util.primitive.iterator.ByteIterator;
import net.morilib.util.primitive.iterator.IntegerIterator;

public class ByteBitSet
extends AbstractByteSet
implements ByteSortedSet {
    private static final BitSet2Class BYTE_CLS = new BitSet2Class(-128, 127);
    private BitSet2 bits = BYTE_CLS.newInstance();

    public ByteBitSet(ByteCollection a) {
        this.addAllByte(a);
    }

    @Override
    public boolean addByte(byte v) {
        return this.bits.add(v);
    }

    @Override
    public boolean addAllByte(ByteCollection a) {
        ByteSet s = a.toSet();
        if (s instanceof ByteBitSet) {
            return this.bits.addAll(((ByteBitSet)s).bits);
        }
        if (s instanceof ByteCollections.UnmodifiableSet) {
            return this.addAllByte(((ByteCollections.UnmodifiableSet)s).wrapee);
        }
        return super.addAllByte((ByteCollection)s);
    }

    @Override
    public void clear() {
        this.bits.clear();
    }

    @Override
    public boolean containsByte(byte v) {
        return this.bits.contains(v);
    }

    @Override
    public boolean containsAllByte(ByteCollection a) {
        ByteSet s = a.toSet();
        if (s instanceof ByteBitSet) {
            return this.bits.containsAll(((ByteBitSet)s).bits);
        }
        if (s instanceof ByteCollections.UnmodifiableSet) {
            return this.containsAllByte(((ByteCollections.UnmodifiableSet)s).wrapee);
        }
        return super.containsAllByte(s);
    }

    @Override
    public boolean isEmpty() {
        return this.bits.isEmpty();
    }

    @Override
    public ByteIterator byteIterator() {
        return new Itr(this.bits.iterator());
    }

    @Override
    public boolean removeByte(byte v) {
        return this.bits.remove(v);
    }

    @Override
    public boolean removeAllByte(ByteCollection a) {
        ByteSet s = a.toSet();
        if (s instanceof ByteBitSet) {
            return this.bits.removeAll(((ByteBitSet)s).bits);
        }
        if (s instanceof ByteCollections.UnmodifiableSet) {
            return this.removeAllByte(((ByteCollections.UnmodifiableSet)s).wrapee);
        }
        return super.removeAllByte(s);
    }

    @Override
    public boolean retainAllByte(ByteCollection a) {
        ByteSet s = a.toSet();
        if (s instanceof ByteBitSet) {
            return this.bits.retainAll(((ByteBitSet)s).bits);
        }
        if (s instanceof ByteCollections.UnmodifiableSet) {
            return this.retainAllByte(((ByteCollections.UnmodifiableSet)s).wrapee);
        }
        return super.retainAllByte(s);
    }

    @Override
    public int size() {
        return this.bits.size();
    }

    @Override
    public byte first() {
        return (byte)this.bits.first();
    }

    @Override
    public ByteSortedSet headSet(byte v) {
        return this.collect(ByteCollections.interval(v, (byte)127));
    }

    @Override
    public ByteSortedSet subSet(byte s, byte e) {
        if (s > e) {
            throw new IllegalArgumentException();
        }
        return this.collect(ByteCollections.interval(s, e));
    }

    @Override
    public ByteSortedSet tailSet(byte v) {
        return this.collect(ByteCollections.interval((byte)-128, v));
    }

    @Override
    public byte last() {
        return (byte)this.bits.last();
    }

    @Override
    public ByteSortedSet collect(ByteSortedSet set) {
        ByteBitSet r = new ByteBitSet(this);
        r.removeAllByte(set);
        return ByteCollections.unmodifiableSortedSet(r);
    }

    private class Itr
    implements ByteIterator {
        private IntegerIterator itr;

        private Itr(IntegerIterator itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public byte next() {
            return (byte)this.itr.next();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }
}

