/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import net.morilib.util.primitive.AbstractByteSet;
import net.morilib.util.primitive.ByteCollection;
import net.morilib.util.primitive.iterator.ByteIterator;

public class ByteHashSet
extends AbstractByteSet
implements Serializable {
    private static final long serialVersionUID = 4823620077843167065L;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private transient Ent[] ent;
    private transient int size;
    private final float loadFactor;
    private int threshold;
    private volatile transient int modCount;

    /*
     * Unable to fully structure code
     */
    public ByteHashSet(int initialCapacity, float loadFactor) {
        block3: {
            super();
            this.modCount = 0;
            cp = 1;
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
            }
            if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
                throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
            }
            if (initialCapacity < 0x40000000) ** GOTO lbl12
            cp = 0x40000000;
            break block3;
lbl-1000:
            // 1 sources

            {
                cp <<= 1;
lbl12:
                // 2 sources

                ** while (cp < initialCapacity)
            }
        }
        this.ent = new Ent[cp];
        this.size = 0;
        this.threshold = (int)((float)cp * loadFactor + 1.0f);
        this.loadFactor = loadFactor;
    }

    public ByteHashSet(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public ByteHashSet(float loadFactor) {
        this(16, loadFactor);
    }

    public ByteHashSet() {
        this(16, 0.75f);
    }

    public ByteHashSet(ByteCollection col) {
        this(16, 0.75f);
        this.addAllByte(col);
    }

    @Override
    public ByteIterator byteIterator() {
        return new ByteIterator(){
            private int ptr = -1;
            private Ent e = this._next();
            private Ent remove = null;
            private int exModCount;
            {
                this.exModCount = ByteHashSet.this.modCount;
            }

            /*
             * Unable to fully structure code
             */
            private Ent _next() {
                v0 = this.e = this.ptr < 0 ? null : Ent.access$0(this.e);
                if (this.e == null) ** GOTO lbl6
                return this.e;
lbl-1000:
                // 1 sources

                {
                    if (ByteHashSet.access$1(ByteHashSet.this)[this.ptr] == null) continue;
                    return ByteHashSet.access$1(ByteHashSet.this)[this.ptr];
lbl6:
                    // 2 sources

                    ** while (++this.ptr < ByteHashSet.access$1((ByteHashSet)ByteHashSet.this).length)
                }
lbl7:
                // 1 sources

                return null;
            }

            @Override
            public boolean hasNext() {
                return this.e != null;
            }

            @Override
            public byte next() {
                this.remove = this.e;
                if (this.e == null) {
                    throw new NoSuchElementException();
                }
                if (this.exModCount != ByteHashSet.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                this.e = this._next();
                return this.remove.value;
            }

            @Override
            public void remove() {
                if (this.remove == null) {
                    throw new IllegalStateException();
                }
                ByteHashSet.this.removeByte(this.e.value);
                this.exModCount = ByteHashSet.this.modCount;
                this.remove = null;
            }
        };
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        int i = 0;
        while (i < this.ent.length) {
            this.ent[i] = null;
            ++i;
        }
    }

    protected int getHash(byte k) {
        return k;
    }

    private Ent _get(byte k) {
        int h = this.getHash(k) % this.ent.length;
        return this.ent[h] != null ? this.ent[h].searchEntry(k) : null;
    }

    @Override
    public boolean containsByte(byte k) {
        return this._get(k) != null;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private void resize() {
        if (this.size > this.threshold && this.ent.length < 0x40000000) {
            int ns = this.ent.length;
            while (this.size > this.threshold) {
                this.threshold = (int)((float)(ns <<= 1) * this.loadFactor + 1.0f);
            }
            Ent[] ne = new Ent[ns];
            ByteIterator bi = this.byteIterator();
            while (bi.hasNext()) {
                byte b = bi.next();
                int h = this.getHash(b) % ns;
                if (ne[h] == null) {
                    ne[h] = new Ent(b);
                    continue;
                }
                ne[h].putEntry(b);
            }
        }
    }

    @Override
    public boolean addByte(byte v) {
        int h = this.getHash(v) % this.ent.length;
        ++this.modCount;
        if (this.ent[h] == null) {
            ++this.size;
            this.resize();
            this.ent[h] = new Ent(v);
            return false;
        }
        boolean r = this.ent[h].putEntry(v);
        if (!r) {
            ++this.size;
            this.resize();
        }
        return r;
    }

    private boolean _putEntry(byte v) {
        int h = this.getHash(v) % this.ent.length;
        if (this.ent[h] == null) {
            this.ent[h] = new Ent(v);
            return true;
        }
        return this.ent[h].putEntry(v);
    }

    @Override
    public boolean addAllByte(ByteCollection c) {
        int nd = c.size();
        boolean r = false;
        ++this.modCount;
        if (nd == 0) {
            return false;
        }
        this.size += nd;
        this.resize();
        ByteIterator i = c.byteIterator();
        while (i.hasNext()) {
            r = this._putEntry(i.next()) | r;
        }
        return r;
    }

    private Ent _remove(byte k) {
        int h = this.getHash(k) % this.ent.length;
        if (this.ent[h] == null) {
            return null;
        }
        if (k == this.ent[h].value) {
            Ent r = this.ent[h];
            --this.size;
            this.ent[h] = r.next;
            return r;
        }
        --this.size;
        return this.ent[h].removeEntry(k);
    }

    @Override
    public boolean removeByte(byte k) {
        return this._remove(k) != null;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.ent.length);
        s.writeInt(this.size);
        ByteIterator i = this.byteIterator();
        while (i.hasNext()) {
            s.writeByte(i.next());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int cp = s.readInt();
        this.ent = new Ent[cp];
        this.size = s.readInt();
        int i = 0;
        while (i < this.size) {
            this._putEntry(s.readByte());
            ++i;
        }
    }

    static /* synthetic */ Ent[] access$1(ByteHashSet byteHashSet) {
        return byteHashSet.ent;
    }

    private static class Ent {
        private byte value;
        private Ent next;

        private Ent(byte value) {
            this.value = value;
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Ent) {
                Ent e = (Ent)obj;
                return this.value == e.value;
            }
            return false;
        }

        public String toString() {
            return Byte.toString(this.value);
        }

        private Ent searchEntry(byte k) {
            Ent f = this;
            while (f != null) {
                if (k == f.value) {
                    return f;
                }
                f = f.next;
            }
            return null;
        }

        private Ent removeEntry(byte k) {
            Ent g = this;
            Ent f = this.next;
            while (f != null) {
                if (k == f.value) {
                    g.next = f.next;
                    return f;
                }
                g = f;
                f = f.next;
            }
            return null;
        }

        private boolean putEntry(byte k) {
            Ent g = this;
            Ent f = this.next;
            while (f != null) {
                if (k == f.value) {
                    return true;
                }
                g = f;
                f = f.next;
            }
            g.next = new Ent(k);
            return false;
        }
    }
}

