/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.set;

import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.morilib.util.Objects;
import net.morilib.util.SimpleMap;

public class MappedSet<F, E>
extends AbstractSet<E> {
    private Set<F> wrapee;
    private SimpleMap<F, E> composite;

    public MappedSet(Set<F> set, SimpleMap<F, E> map) {
        this.wrapee = set;
        this.composite = map;
    }

    @Override
    public int size() {
        return this.wrapee.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapee.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        for (F f : this.wrapee) {
            if (!Objects.equals(this.composite.map(f), o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        HashSet<E> hasset = new HashSet<E>();
        for (F f : this.wrapee) {
            hasset.add(this.composite.map(f));
        }
        return hasset.iterator();
    }
}

