/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.uvector;

import net.morilib.math.ArrayIntSymmetricGroup;
import net.morilib.math.IntPermutation;
import net.morilib.util.Bytes;

public final class Endianness {
    public static final Endianness BIG = new Endianness("BIG", ArrayIntSymmetricGroup.getInstance(2).getIdentity(), ArrayIntSymmetricGroup.getInstance(4).getIdentity(), ArrayIntSymmetricGroup.getInstance(8).getIdentity());
    public static final Endianness LITTLE;
    private String code;
    private IntPermutation p2;
    private IntPermutation p4;
    private IntPermutation p8;

    static {
        int[] nArray = new int[2];
        nArray[0] = 1;
        int[] nArray2 = new int[4];
        nArray2[0] = 3;
        nArray2[1] = 2;
        nArray2[2] = 1;
        int[] nArray3 = new int[8];
        nArray3[0] = 7;
        nArray3[1] = 6;
        nArray3[2] = 5;
        nArray3[3] = 4;
        nArray3[4] = 3;
        nArray3[5] = 2;
        nArray3[6] = 1;
        LITTLE = Endianness.getInstance("LITTLE", nArray, nArray2, nArray3);
    }

    private Endianness(String code, IntPermutation p2, IntPermutation p4, IntPermutation p8) {
        this.code = code;
        this.p2 = p2;
        this.p4 = p4;
        this.p8 = p8;
    }

    private static int[] mapinc(int[] src) {
        if (src == null) {
            throw new NullPointerException();
        }
        int[] res = new int[src.length];
        int bit = 0;
        int i = 0;
        while (i < src.length) {
            if (src[i] < 0 || src[i] >= src.length) {
                throw new IndexOutOfBoundsException(String.valueOf(src[i]));
            }
            res[i] = src[i] + 1;
            bit |= 1 << i;
            ++i;
        }
        if (bit != (1 << src.length) - 1) {
            throw new IllegalArgumentException("map of endianness bit is not unique");
        }
        return res;
    }

    public static Endianness getInstance(String code, int[] end2, int[] end4, int[] end8) {
        if (end2.length != 2) {
            throw new IllegalArgumentException("short endian must have 2 integers");
        }
        if (end4.length != 4) {
            throw new IllegalArgumentException("int endian must have 4 integers");
        }
        if (end8.length != 8) {
            throw new IllegalArgumentException("long endian must have 8 integers");
        }
        int[] p2 = Endianness.mapinc(end2);
        int[] p4 = Endianness.mapinc(end4);
        int[] p8 = Endianness.mapinc(end8);
        return new Endianness(code, ArrayIntSymmetricGroup.getInstance(2).newElement(p2), ArrayIntSymmetricGroup.getInstance(4).newElement(p4), ArrayIntSymmetricGroup.getInstance(8).newElement(p8));
    }

    public short readShort(byte[] src, int offset) {
        int i = offset;
        if (i < 0 || i >= src.length - 1) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        short r = (short)(Bytes.ubyteToInt(src[i + this.p2.get(1) - 1]) << 8 | Bytes.ubyteToInt(src[i + this.p2.get(2) - 1]));
        return r;
    }

    public int readInt(byte[] src, int offset) {
        int i = offset;
        if (i < 0 || i >= src.length - 3) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        int r = Bytes.ubyteToInt(src[i + this.p4.get(1) - 1]) << 24 | Bytes.ubyteToInt(src[i + this.p4.get(2) - 1]) << 16 | Bytes.ubyteToInt(src[i + this.p4.get(3) - 1]) << 8 | Bytes.ubyteToInt(src[i + this.p4.get(4) - 1]);
        return r;
    }

    public long readLong(byte[] src, int offset) {
        int i = offset;
        if (i < 0 || i >= src.length - 7) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        long r = Bytes.ubyteToLong(src[i + this.p8.get(1) - 1]) << 56 | Bytes.ubyteToLong(src[i + this.p8.get(2) - 1]) << 48 | Bytes.ubyteToLong(src[i + this.p8.get(3) - 1]) << 40 | Bytes.ubyteToLong(src[i + this.p8.get(4) - 1]) << 32 | Bytes.ubyteToLong(src[i + this.p8.get(5) - 1]) << 24 | Bytes.ubyteToLong(src[i + this.p8.get(6) - 1]) << 16 | Bytes.ubyteToLong(src[i + this.p8.get(7) - 1]) << 8 | Bytes.ubyteToLong(src[i + this.p8.get(8) - 1]);
        return r;
    }

    public int readuShort(byte[] src, int offset) {
        int i = offset;
        if (i < 0 || i >= src.length - 1) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        int r = Bytes.ubyteToInt(src[i + this.p2.get(1) - 1]) << 8 | Bytes.ubyteToInt(src[i + this.p2.get(2) - 1]);
        return r;
    }

    public long readuInt(byte[] src, int offset) {
        int i = offset;
        if (i < 0 || i >= src.length - 3) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        long r = Bytes.ubyteToLong(src[i + this.p4.get(1) - 1]) << 24 | Bytes.ubyteToLong(src[i + this.p4.get(2) - 1]) << 16 | Bytes.ubyteToLong(src[i + this.p4.get(3) - 1]) << 8 | Bytes.ubyteToLong(src[i + this.p4.get(4) - 1]);
        return r;
    }

    public void writeShort(byte[] src, int offset, short value) {
        int i = offset;
        if (i < 0 || i >= src.length - 1) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        src[i + this.p2.get((int)1) - 1] = (byte)(value >>> 8);
        src[i + this.p2.get((int)2) - 1] = (byte)value;
    }

    public void writeInt(byte[] src, int offset, int value) {
        int i = offset;
        if (i < 0 || i >= src.length - 3) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        src[i + this.p4.get((int)1) - 1] = (byte)(value >>> 24);
        src[i + this.p4.get((int)2) - 1] = (byte)(value >>> 16);
        src[i + this.p4.get((int)3) - 1] = (byte)(value >>> 8);
        src[i + this.p4.get((int)4) - 1] = (byte)value;
    }

    public void writeLong(byte[] src, int offset, long value) {
        int i = offset;
        if (i < 0 || i >= src.length - 7) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        src[i + this.p8.get((int)1) - 1] = (byte)(value >>> 56);
        src[i + this.p8.get((int)2) - 1] = (byte)(value >>> 48);
        src[i + this.p8.get((int)3) - 1] = (byte)(value >>> 40);
        src[i + this.p8.get((int)4) - 1] = (byte)(value >>> 32);
        src[i + this.p8.get((int)5) - 1] = (byte)(value >>> 24);
        src[i + this.p8.get((int)6) - 1] = (byte)(value >>> 16);
        src[i + this.p8.get((int)7) - 1] = (byte)(value >>> 8);
        src[i + this.p8.get((int)8) - 1] = (byte)value;
    }

    public void writeuShort(byte[] src, int offset, int value) {
        int i = offset;
        if (i < 0 || i >= src.length - 1) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        src[i + this.p2.get((int)1) - 1] = (byte)(value >>> 8);
        src[i + this.p2.get((int)2) - 1] = (byte)value;
    }

    public void writeuInt(byte[] src, int offset, long value) {
        int i = offset;
        if (i < 0 || i >= src.length - 3) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        src[i + this.p4.get((int)1) - 1] = (byte)(value >>> 24);
        src[i + this.p4.get((int)2) - 1] = (byte)(value >>> 16);
        src[i + this.p4.get((int)3) - 1] = (byte)(value >>> 8);
        src[i + this.p4.get((int)4) - 1] = (byte)value;
    }

    public String toString() {
        return this.code;
    }
}

