/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.nfa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.morilib.automata.nfa.CompoundNFA;
import net.morilib.automata.nfa.NFAObject;
import net.morilib.automata.nfa.NFAState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NFAConcatenation<T, A, B>
extends CompoundNFA<T, A, B> {
    private NFAConcatenation() {
    }

    public static <T, A, B> NFAConcatenation<T, A, B> newInstance(List<NFAObject<T, A, B>> col) {
        NFAConcatenation<T, A, B> res = new NFAConcatenation<T, A, B>();
        if (col.size() < 2) {
            throw new IllegalArgumentException();
        }
        res.nfas = new ArrayList<NFAObject<T, A, B>>(col);
        return res;
    }

    public static <T, A, B> NFAConcatenation<T, A, B> newInstance(NFAObject<T, A, B>[] arr) {
        NFAConcatenation<T, A, B> res = new NFAConcatenation<T, A, B>();
        if (arr.length < 2) {
            throw new IllegalArgumentException();
        }
        res.nfas = Arrays.asList(arr);
        return res;
    }

    public static <T, A, B> NFAConcatenation<T, A, B> newInstance(NFAObject<T, A, B> a, NFAObject<T, A, B> b) {
        NFAConcatenation<T, A, B> res = new NFAConcatenation<T, A, B>();
        res.nfas = new ArrayList();
        res.nfas.add(a);
        res.nfas.add(b);
        return res;
    }

    @Override
    void addInitialStates(Set<NFAState> res) {
        ((NFAObject)this.nfas.get(0)).addInitialStates(res);
    }

    @Override
    void addStatesEpsilon(Set<NFAState> res, NFAState state) {
        int i = 0;
        while (i < this.nfas.size()) {
            if (((NFAObject)this.nfas.get(i)).isState(state)) {
                ((NFAObject)this.nfas.get(i)).addStatesEpsilon(res, state);
                if (i < this.nfas.size() - 1 && ((NFAObject)this.nfas.get(i)).isFinal(state)) {
                    ((NFAObject)this.nfas.get(i + 1)).addInitialStates(res);
                }
                return;
            }
            ++i;
        }
    }

    @Override
    public boolean isState(NFAState o) {
        int i = 0;
        while (i < this.nfas.size()) {
            if (((NFAObject)this.nfas.get(i)).isState(o)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isInitialState(NFAState o) {
        return ((NFAObject)this.nfas.get(0)).isInitialState(o);
    }

    @Override
    public boolean isFinal(NFAState o) {
        return ((NFAObject)this.nfas.get(this.nfas.size() - 1)).isFinal(o);
    }

    public String toString() {
        return "{" + this.nfas + "}";
    }

    @Override
    public Set<NFAState> getAcceptedStates() {
        return ((NFAObject)this.nfas.get(this.nfas.size() - 1)).getAcceptedStates();
    }
}

