/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.grammar.lr;

import java.util.HashMap;
import java.util.Map;
import net.morilib.grammar.lr.ContextFreeReduceAction;
import net.morilib.grammar.lr.ContextFreeRule;
import net.morilib.grammar.lr.GrammarSymbol;
import net.morilib.grammar.lr.LR1Table;
import net.morilib.grammar.lr.LRParseException;
import net.morilib.grammar.lr.LexicalAnalyser;
import net.morilib.grammar.lr.SemanticAttributes;
import net.morilib.util.ArrayListStack;
import net.morilib.util.LinkedListStack;
import net.morilib.util.Stack2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRParser<T> {
    private LR1Table table;
    private Map<ContextFreeRule, ContextFreeReduceAction<T>> actionMap = new HashMap<ContextFreeRule, ContextFreeReduceAction<T>>();

    public LRParser(LR1Table table) {
        this.table = table;
    }

    public ContextFreeReduceAction<T> getAction(ContextFreeRule rule) {
        return this.actionMap.get(rule);
    }

    public void setAction(ContextFreeRule rule, ContextFreeReduceAction<T> action) {
        this.actionMap.put(rule, action);
    }

    public void removeAction(ContextFreeRule rule) {
        this.actionMap.remove(rule);
    }

    public T parse(LexicalAnalyser<T> lexer) throws LRParseException {
        LR1Table.Action action;
        LinkedListStack<Strct> syntax = new LinkedListStack<Strct>();
        ArrayListStack<T> semantics = new ArrayListStack<T>();
        LexicalAnalyser.Token<T> a = lexer.nextToken();
        Strct s0 = new Strct(this.table.getInitialStateID(), null);
        syntax.push(s0);
        while (true) {
            Strct s;
            if ((s = (Strct)syntax.peek()) == null) {
                throw new NullPointerException("");
            }
            action = this.table.action(s.id, a.getGrammarSymbol());
            if (action == null) {
                throw new LRParseException(a.toString());
            }
            if (action.isShift()) {
                syntax.push(new Strct(action.getNextStateID(), a.getGrammarSymbol()));
                semantics.push(a.getAttribute());
                a = lexer.nextToken();
                continue;
            }
            if (!action.isReduce()) break;
            ContextFreeRule rule = action.getReduceRule();
            Object res = null;
            ContextFreeReduceAction ex = this.getAction(rule);
            if (ex != null) {
                SStack stk = new SStack(rule, semantics);
                res = ex.action(rule, stk);
            }
            syntax.pop(rule.getDerivedSymbolLength());
            semantics.pop(rule.getDerivedSymbolLength());
            Strct ss = (Strct)syntax.peek();
            syntax.push(new Strct(this.table.goTo(ss.id, rule.getLeftSymbol()), rule.getLeftSymbol()));
            semantics.push(res);
        }
        if (action.isAccept()) {
            return (T)semantics.peek();
        }
        throw new IllegalStateException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SStack<T>
    implements SemanticAttributes<T> {
        private Stack2<T> stack;
        private ContextFreeRule rule;

        private SStack(ContextFreeRule rule, Stack2<T> stack) {
            this.rule = rule;
            this.stack = stack;
        }

        @Override
        public T get(int index) {
            if (index >= this.rule.getDerivedSymbolLength()) {
                throw new IndexOutOfBoundsException();
            }
            return this.stack.get(this.stack.size() - this.rule.getDerivedSymbolLength() + index);
        }
    }

    private static final class Strct {
        private int id;
        private GrammarSymbol symbol;

        private Strct(int id, GrammarSymbol symbol) {
            this.id = id;
            this.symbol = symbol;
        }

        public String toString() {
            return "(" + this.id + ":" + this.symbol + ")";
        }
    }
}

