/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lang.number;

import net.morilib.util.BitUtils;

public final class IEEE754Double {
    private static final int EMAX = 2047;
    public static final int MAX_EXPONENT = 1023;
    public static final int MIN_NORMALIZED_EXPONENT = -1023;
    public static final int MIN_EXPONENT = -1075;
    public static final int FRACTION_BITS = 52;

    private static double _getDouble(int sign, int exp, long frac) {
        long l = 0L;
        l |= sign == 1 ? Long.MIN_VALUE : 0L;
        if (exp > -1023) {
            l |= (long)(exp + 1023 & 0x7FF) << 51;
        }
        return Double.longBitsToDouble(l |= frac & 0xFFFFFFFFFFFFFL);
    }

    public static int getSignumField(long x) {
        return x < 0L ? 1 : 0;
    }

    public static int getExponentField(long x) {
        return (int)((x & 0x7FF0000000000000L) >> 51);
    }

    public static long getFractionField(long x) {
        return x & 0xFFFFFFFFFFFFFL;
    }

    public static int getSignum(long x) {
        return IEEE754Double.getSignumField(x) == 0 ? 1 : -1;
    }

    public static int getExponent(long x) {
        int e = IEEE754Double.getExponentField(x);
        long f = IEEE754Double.getFractionField(x);
        if (e == 2047) {
            if (f == 0L) {
                return 1024;
            }
            throw new ArithmeticException("Not a number");
        }
        if (e > 0) {
            return e;
        }
        return -1075 + BitUtils.getMsb(f) - 1;
    }

    public static boolean isNormalized(long x) {
        int e = IEEE754Double.getExponentField(x);
        return e > 0 && e < 2047;
    }

    public static int getSignumField(double x) {
        return IEEE754Double.getSignumField(Double.doubleToRawLongBits(x));
    }

    public static int getExponentField(double x) {
        return IEEE754Double.getExponentField(Double.doubleToRawLongBits(x));
    }

    public static long getFractionField(double x) {
        return IEEE754Double.getFractionField(Double.doubleToRawLongBits(x));
    }

    public static int getSignum(double x) {
        return IEEE754Double.getSignum(Double.doubleToRawLongBits(x));
    }

    public static int getExponent(double x) {
        return IEEE754Double.getExponent(Double.doubleToRawLongBits(x));
    }

    public static boolean isNormalized(float x) {
        return IEEE754Double.isNormalized(Double.doubleToRawLongBits(x));
    }

    public static double inclement(double x) {
        long l = Double.doubleToLongBits(x);
        int s = IEEE754Double.getSignumField(l);
        int e = IEEE754Double.getExponentField(l);
        long f = IEEE754Double.getFractionField(l);
        if (x == Double.POSITIVE_INFINITY) {
            return x;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return Double.MIN_VALUE;
        }
        if (x == Double.MAX_VALUE) {
            return Double.POSITIVE_INFINITY;
        }
        if (Double.isNaN(x)) {
            return x;
        }
        if (f == 0xFFFFFFFFFFFFFL) {
            return IEEE754Double._getDouble(s, e + 1, f << 1);
        }
        return IEEE754Double._getDouble(s, e, f + 1L);
    }

    public static double declement(double x) {
        long l = Double.doubleToLongBits(x);
        int s = IEEE754Double.getSignumField(l);
        int e = IEEE754Double.getExponentField(l);
        long f = IEEE754Double.getFractionField(l);
        if (x == Double.POSITIVE_INFINITY) {
            return Double.MAX_VALUE;
        }
        if (x == Double.NEGATIVE_INFINITY) {
            return x;
        }
        if (x == Double.MIN_VALUE) {
            return Double.NEGATIVE_INFINITY;
        }
        if (Double.isNaN(x)) {
            return x;
        }
        if (f == 0L) {
            return IEEE754Double._getDouble(s, e - 1, 1L);
        }
        return IEEE754Double._getDouble(s, e, f - 1L);
    }
}

