/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.IntLispUtils;
import net.morilib.lisp.JavaException;
import net.morilib.lisp.JavaNull;
import net.morilib.lisp.JavaTargetException;
import net.morilib.lisp.ParameterNotFoundException;
import net.morilib.lisp.Undef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaUtils {
    private static final Object NOTFOUND = new Object();

    private JavaUtils() {
    }

    private static Object invokeMethod0(Method mth, Object obj, List<Datum> lst) throws ParameterNotFoundException {
        boolean va;
        Class<?>[] cls = mth.getParameterTypes();
        if (IntLispUtils.isSameClasses(cls, lst, va = mth.isVarArgs())) {
            Object[] args = IntLispUtils.toJavaInstances(cls, lst, va);
            return JavaUtils.invoke(mth, obj, args);
        }
        return NOTFOUND;
    }

    static Object invoke(Method mtd, Object obj, Object ... args) throws ParameterNotFoundException {
        try {
            Object res = mtd.invoke(obj, args);
            if (mtd.getReturnType().isAssignableFrom(Void.TYPE)) {
                return Undef.UNDEF;
            }
            return res == null ? JavaNull.JAVA_NULL : res;
        }
        catch (IllegalArgumentException e) {
            throw new JavaException(e);
        }
        catch (IllegalAccessException e) {
            throw new JavaException(e);
        }
        catch (InvocationTargetException e) {
            throw new JavaTargetException(e.getCause());
        }
        catch (NullPointerException e) {
            throw new ParameterNotFoundException();
        }
    }

    static Object invokeMethod(Method mth, Object obj, List<Datum> lst) throws ParameterNotFoundException {
        Object res = JavaUtils.invokeMethod0(mth, obj, lst);
        if (res == NOTFOUND) {
            throw new ParameterNotFoundException();
        }
        return res;
    }

    public static Object invokeMethod(Class<?> klass, Object obj, String name, List<Datum> lst) throws ParameterNotFoundException {
        Method[] cns = klass.getMethods();
        int i = 0;
        while (i < cns.length) {
            Object res;
            String cnm = cns[i].getName();
            if (cnm.equals(name) && (res = JavaUtils.invokeMethod0(cns[i], obj, lst)) != NOTFOUND) {
                return res;
            }
            ++i;
        }
        throw new ParameterNotFoundException();
    }

    public static Object invokeMethod(Object obj, String name, List<Datum> lst) throws ParameterNotFoundException {
        return JavaUtils.invokeMethod(obj.getClass(), obj, name, lst);
    }

    public static Object invokeGetter(Object obj, PropertyDescriptor pd) throws ParameterNotFoundException {
        Method mtd = pd.getReadMethod();
        if (mtd == null) {
            throw new ParameterNotFoundException();
        }
        Class<?>[] prm = mtd.getParameterTypes();
        if (prm.length != 0) {
            throw new ParameterNotFoundException();
        }
        return JavaUtils.invoke(mtd, obj, new Object[0]);
    }

    public static Object invokeGetter(Object obj, String prop) throws IntrospectionException, ParameterNotFoundException {
        PropertyDescriptor pd = new PropertyDescriptor(prop, obj.getClass());
        return JavaUtils.invokeGetter(obj, pd);
    }

    static Object invokeSetter(Object obj, PropertyDescriptor pd, Datum d) throws ParameterNotFoundException {
        Method mtd = pd.getWriteMethod();
        if (mtd == null) {
            throw new ParameterNotFoundException();
        }
        Class<?>[] prm = mtd.getParameterTypes();
        if (prm.length != 1 || !IntLispUtils.isSameClass(prm[0], d)) {
            throw new ParameterNotFoundException();
        }
        return JavaUtils.invoke(mtd, obj, IntLispUtils.toJavaInstance(prm[0], d));
    }

    public static Object invokeSetter(Object obj, String prop, Datum d) throws IntrospectionException, ParameterNotFoundException {
        PropertyDescriptor pd = new PropertyDescriptor(prop, obj.getClass());
        return JavaUtils.invokeSetter(obj, pd, d);
    }

    static Object invokeGetter(Object obj, IndexedPropertyDescriptor pd, int index) throws ParameterNotFoundException {
        Method mtd = pd.getIndexedReadMethod();
        if (mtd == null) {
            throw new ParameterNotFoundException();
        }
        Class<?>[] prm = mtd.getParameterTypes();
        if (prm.length != 1 || !IntLispUtils.isAssignableInt(prm[0])) {
            throw new ParameterNotFoundException();
        }
        return JavaUtils.invoke(mtd, obj, index);
    }

    public static Object invokeGetter(Object obj, String prop, int index) throws ParameterNotFoundException {
        try {
            IndexedPropertyDescriptor pd = new IndexedPropertyDescriptor(prop, obj.getClass());
            return JavaUtils.invokeGetter(obj, pd, index);
        }
        catch (IntrospectionException e) {
            throw new ParameterNotFoundException(e);
        }
    }

    static Object invokeSetter(Object obj, IndexedPropertyDescriptor pd, int index, Datum d) throws ParameterNotFoundException {
        Method mtd = pd.getIndexedWriteMethod();
        if (mtd == null) {
            throw new ParameterNotFoundException();
        }
        Class<?>[] prm = mtd.getParameterTypes();
        if (prm.length != 2 || !IntLispUtils.isAssignableInt(prm[0]) || !IntLispUtils.isSameClass(prm[1], d)) {
            throw new ParameterNotFoundException();
        }
        return JavaUtils.invoke(mtd, obj, index, IntLispUtils.toJavaInstance(prm[1], d));
    }

    public static Object invokeSetter(Object obj, String prop, int index, Datum d) throws ParameterNotFoundException {
        try {
            IndexedPropertyDescriptor pd = new IndexedPropertyDescriptor(prop, obj.getClass());
            return JavaUtils.invokeSetter(obj, pd, index, d);
        }
        catch (IntrospectionException e) {
            throw new ParameterNotFoundException(e);
        }
    }

    public static Object getField(Object obj, String field) throws NoSuchFieldException {
        try {
            Field f = obj.getClass().getField(field);
            return f.get(obj);
        }
        catch (SecurityException e) {
            throw new JavaException(e);
        }
        catch (IllegalArgumentException e) {
            throw new JavaException(e);
        }
        catch (IllegalAccessException e) {
            throw new JavaException(e);
        }
    }

    public static void setField(Object obj, String field, Datum d) throws NoSuchFieldException, ParameterNotFoundException {
        try {
            Field f = obj.getClass().getField(field);
            if (!IntLispUtils.isSameClass(f.getType(), d)) {
                throw new ParameterNotFoundException();
            }
            Object dj = IntLispUtils.toJavaInstance(f.getType(), d);
            f.set(obj, dj);
        }
        catch (IllegalArgumentException e) {
            throw new JavaException(e);
        }
        catch (IllegalAccessException e) {
            throw new JavaException(e);
        }
    }
}

