/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispException;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.ReadException;

public final class LispMessage {
    private static final String CLSNAME = "net.morilib.lisp.init.messages";
    private static Map<Locale, LispMessage> instances = new HashMap<Locale, LispMessage>();
    private ResourceBundle messages;

    private LispMessage(Locale lc) {
        this.messages = ResourceBundle.getBundle(CLSNAME, lc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LispMessage getInstance(Locale lc) {
        LispMessage res = instances.get(lc);
        if (res != null) return res;
        Class<LispMessage> clazz = LispMessage.class;
        synchronized (LispMessage.class) {
            res = new LispMessage(lc);
            instances.put(lc, res);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return res;
        }
    }

    public static LispMessage getInstance() {
        return LispMessage.getInstance(Locale.getDefault());
    }

    public String get(String prop) {
        try {
            return this.messages.getString(prop);
        }
        catch (MissingResourceException e) {
            return String.valueOf(this.messages.getString("err.unknown")) + "(" + e.getKey() + ")";
        }
    }

    public String get(String prop, String msg2) {
        return String.valueOf(this.get(prop)) + ":" + msg2;
    }

    public String get(String prop, Datum d) {
        return String.valueOf(this.get(prop)) + ":" + LispUtils.getResult(d);
    }

    public LispException getError(String prop) {
        return new LispException(prop, this.get(prop));
    }

    public LispException getError(String prop, String msg2) {
        return new LispException(prop, this.get(prop, msg2));
    }

    public LispException getError(String prop, Datum d) {
        return new LispException(prop, this.get(prop, d));
    }

    public LispException getError(String prop, Throwable th) {
        return new LispException(prop, this.get(prop), th);
    }

    public LispException getError(String prop, String msg2, Throwable th) {
        return new LispException(prop, this.get(prop, msg2), th);
    }

    public LispException getError(String prop, Datum d, Throwable th) {
        return new LispException(prop, this.get(prop, d), th);
    }

    public ReadException getReadError(String prop) {
        return new ReadException(prop, this.get(prop));
    }

    public ReadException getReadError(String prop, String msg2) {
        return new ReadException(prop, this.get(prop, msg2));
    }

    public ReadException getReadError(String prop, Datum d) {
        return new ReadException(prop, this.get(prop, d));
    }

    public LispException getUncaughtException(LispException e) {
        return new LispException("err.srfi18.uncaught", this.get("err.srfi18.uncaught"), e);
    }
}

