/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.collection;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.collection.ImmutableException;
import net.morilib.lisp.collection.LispEnumeration;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.util.Iterators;

public interface LispCollection
extends LispEnumeration {
    public Symbol getCollectionName();

    public Datum toList();

    public int count(Datum var1);

    public int size();

    public Datum prototype();

    public Datum clear() throws ImmutableException;

    public boolean equalTo(LispCollection var1);

    public boolean equalTo(LispCollection var1, Procedure var2, Environment var3, LispMessage var4);

    public Datum duplicate();

    public boolean contains(Datum var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectionClear
    extends UnaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public CollectionClear(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            return ((LispCollection)((Object)c1a)).prototype();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectionClearS
    extends UnaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public CollectionClearS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                return ((LispCollection)((Object)c1a)).clear();
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", c1a);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectionCopy
    extends UnaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public CollectionCopy(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            return ((LispCollection)((Object)c1a)).duplicate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectionCount
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public CollectionCount(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            return LispInteger.valueOf(((LispCollection)((Object)c1a)).count(c2a));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectionEq
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public CollectionEq(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            itr = new ConsIterator(body);
            p = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            d = null;
            r = true;
            if (p instanceof Procedure) ** GOTO lbl16
            throw mesg.getError("err.require.procedure", p);
lbl-1000:
            // 1 sources

            {
                e = itr.next();
                this.checkType(e, mesg);
                if (d == null) {
                    d = (LispCollection)e;
                    continue;
                }
                if (!(e instanceof LispCollection)) {
                    throw mesg.getError("err.srfi44.require.collection", e);
                }
                if (!r) continue;
                r = d.equalTo((LispCollection)e, (Procedure)p, env, mesg);
lbl16:
                // 4 sources

                ** while (itr.hasNext())
            }
lbl17:
            // 1 sources

            SubrUtils.checkTerminated(itr, body, mesg);
            return LispBoolean.getInstance(r);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectionGetAny
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public CollectionGetAny(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum th = Iterators.nextIf(itr, null);
            this.checkType(d, mesg);
            LispCollection c = (LispCollection)((Object)d);
            Iterator iz = c.iterator();
            if (iz.hasNext()) {
                return (Datum)iz.next();
            }
            if (th == null) {
                return LispBoolean.FALSE;
            }
            return Scheme.callva(th, env, mesg, new Datum[0]);
        }
    }

    public static class CollectionName
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispCollection) {
                return ((LispCollection)((Object)c1a)).getCollectionName();
            }
            throw mesg.getError("err.srfi44.require.collection", c1a);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectionSize
    extends UnaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public CollectionSize(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            int i = ((LispCollection)((Object)c1a)).size();
            return i >= 0 ? LispInteger.valueOf(i) : LispBoolean.FALSE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CollectionToList
    extends UnaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public CollectionToList(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            return ((LispCollection)((Object)c1a)).toList();
        }
    }

    public static class IsCollection
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispCollection);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IsCollectionContains
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public IsCollectionContains(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            return LispBoolean.getInstance(((LispCollection)((Object)c1a)).contains(c2a));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IsCollectionEmpty
    extends UnaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public IsCollectionEmpty(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            return LispBoolean.getInstance(((LispCollection)((Object)c1a)).size() == 0);
        }
    }
}

