/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.collection;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.collection.ImmutableException;
import net.morilib.lisp.collection.LispDirectionalCollection;
import net.morilib.lisp.collection.LispSequence;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.TernaryArgs;
import net.morilib.lisp.subr.UnaryArgs;

public interface LispFlexibleSequence
extends LispSequence,
LispDirectionalCollection {
    public Datum copyInsert(int var1, Datum var2);

    public Datum insert(int var1, Datum var2) throws ImmutableException;

    public Datum copyDelete(int var1);

    public Datum delete(int var1) throws ImmutableException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FlexibleSequenceDeleteAt
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public FlexibleSequenceDeleteAt(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            int i = SubrUtils.getSmallIntegerExact(c2a, mesg);
            this.checkType(c1a, mesg);
            try {
                return ((LispFlexibleSequence)((Object)c1a)).copyDelete(i);
            }
            catch (IndexOutOfBoundsException e) {
                throw mesg.getError("err.srfi44.outofbounds", LispInteger.valueOf(i));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FlexibleSequenceDeleteAtS
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public FlexibleSequenceDeleteAtS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            int i = SubrUtils.getSmallIntegerExact(c2a, mesg);
            this.checkType(c1a, mesg);
            try {
                return ((LispFlexibleSequence)((Object)c1a)).delete(i);
            }
            catch (IndexOutOfBoundsException e) {
                throw mesg.getError("err.srfi44.outofbounds", LispInteger.valueOf(i));
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", c1a);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FlexibleSequenceInsert
    extends TernaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public FlexibleSequenceInsert(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
            int i = SubrUtils.getSmallIntegerExact(c2a, mesg);
            this.checkType(c1a, mesg);
            try {
                return ((LispFlexibleSequence)((Object)c1a)).copyInsert(i, c3a);
            }
            catch (IndexOutOfBoundsException e) {
                throw mesg.getError("err.srfi44.outofbounds", LispInteger.valueOf(i));
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), c3a);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FlexibleSequenceInsertS
    extends TernaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public FlexibleSequenceInsertS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
            int i = SubrUtils.getSmallIntegerExact(c2a, mesg);
            this.checkType(c1a, mesg);
            try {
                return ((LispFlexibleSequence)((Object)c1a)).insert(i, c3a);
            }
            catch (IndexOutOfBoundsException e) {
                throw mesg.getError("err.srfi44.outofbounds", LispInteger.valueOf(i));
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", c1a);
            }
            catch (ClassCastException e) {
                throw mesg.getError(e.getMessage(), c3a);
            }
        }
    }

    public static class IsFlexibleSequence
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispFlexibleSequence);
        }
    }
}

