/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.RegexPattern;
import net.morilib.lisp.Subr;
import net.morilib.lisp.file.LispFiles;
import net.morilib.lisp.file.LispLineCursor;
import net.morilib.lisp.subr.SubrUtils;

public class LispGrepCursor
extends LispLineCursor {
    private RegexPattern pattern;

    public LispGrepCursor(File fn, String enc, RegexPattern pat) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        super(fn, enc);
        this.pattern = pat;
    }

    protected boolean test(String now2) {
        return this.pattern.matches(now2);
    }

    public static class OpenGrepCursor
    extends Subr {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum p = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, "err.argument", body);
            String f = SubrUtils.nextString((Iterator<Datum>)itr, mesg, body);
            String e = SubrUtils.nextString((Iterator<Datum>)itr, null, mesg);
            SubrUtils.checkTerminated(itr, body, mesg);
            if (!(p instanceof RegexPattern)) {
                throw mesg.getError("err.regexp.require.regexp", p);
            }
            try {
                return new LispGrepCursor(LispFiles.getFile(env, f), e, (RegexPattern)p);
            }
            catch (UnsupportedEncodingException e1) {
                throw mesg.getError("err.unsupportedencoding", e);
            }
            catch (FileNotFoundException e1) {
                throw mesg.getError("err.filenotfound", f);
            }
            catch (IOException e1) {
                throw mesg.getError("err.io", e1.getMessage());
            }
        }
    }
}

