/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.painter;

import java.awt.Image;
import java.util.List;
import java.util.Stack;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Undef;
import net.morilib.lisp.painter.BelowPainter;
import net.morilib.lisp.painter.BesidePainter;
import net.morilib.lisp.painter.ImagePainter;
import net.morilib.lisp.painter.Painter;
import net.morilib.lisp.painter.SchlushFrame;
import net.morilib.lisp.painter.geom.MutablePoint2D;

public class DisplayPainter
extends Subr {
    private MutablePoint2D paintImage(SchlushFrame f, ImagePainter p, double x, double y, double rx, double ry, LispMessage mesg) {
        Image img = p.getImageFactory().getImage();
        int w = f.getImageWidth(img);
        int h = f.getImageHeight(img);
        MutablePoint2D ps = f.getCoordinate() != null ? f.getCoordinate().invertSize(f.getWidth(), f.getHeight(), w, h) : new MutablePoint2D(w, h);
        try {
            f.addImage(new SchlushFrame.ImageInfo(img, x, y, ps.getX() * rx, ps.getY() * ry));
        }
        catch (InterruptedException e) {
            throw mesg.getError("err.interrupted");
        }
        return ps;
    }

    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> l = LispUtils.consToList(body, mesg);
        if (l.size() < 4 || l.size() > 6 || l.size() == 5) {
            throw mesg.getError("err.argument", this.symbolName);
        }
        if (!(l.get(0) instanceof SchlushFrame)) {
            throw mesg.getError("err.require.frame", l.get(0));
        }
        if (!(l.get(1) instanceof Painter)) {
            throw mesg.getError("err.require.painter", l.get(1));
        }
        if (!(l.get(2) instanceof LispNumber)) {
            throw mesg.getError("err.require.number", l.get(2));
        }
        if (!((LispNumber)l.get(2)).isReal()) {
            throw mesg.getError("err.require.real", l.get(2));
        }
        if (!(l.get(3) instanceof LispNumber)) {
            throw mesg.getError("err.require.number", l.get(3));
        }
        if (!((LispNumber)l.get(3)).isReal()) {
            throw mesg.getError("err.require.real", l.get(3));
        }
        if (l.size() >= 5) {
            if (!(l.get(4) instanceof LispNumber)) {
                throw mesg.getError("err.require.number", l.get(4));
            }
            if (!((LispNumber)l.get(4)).isReal()) {
                throw mesg.getError("err.require.real", l.get(4));
            }
            if (!(l.get(5) instanceof LispNumber)) {
                throw mesg.getError("err.require.number", l.get(5));
            }
            if (!((LispNumber)l.get(5)).isReal()) {
                throw mesg.getError("err.require.real", l.get(5));
            }
        }
        SchlushFrame f = (SchlushFrame)((Object)l.get(0));
        Painter p = (Painter)l.get(1);
        double x = ((LispNumber)l.get(2)).getRealDouble();
        double y = ((LispNumber)l.get(3)).getRealDouble();
        double rx = l.size() < 5 ? 1.0 : ((LispNumber)l.get(4)).getRealDouble();
        double ry = l.size() < 5 ? 1.0 : ((LispNumber)l.get(5)).getRealDouble();
        Stack<Painter> stk = new Stack<Painter>();
        Stack<Integer> stw = new Stack<Integer>();
        Stack<Integer> sth = new Stack<Integer>();
        Stack<Double> stx = new Stack<Double>();
        Stack<Double> sty = new Stack<Double>();
        Stack<Painter> stz = new Stack<Painter>();
        stk.push(p);
        stz.push(null);
        stw.push(1);
        sth.push(1);
        stx.push(x);
        sty.push(y);
        while (!stk.isEmpty()) {
            Painter p2 = (Painter)stk.pop();
            int w2 = (Integer)stw.pop();
            int h2 = (Integer)sth.pop();
            double x2 = (Double)stx.pop();
            double y2 = (Double)sty.pop();
            Painter bef = (Painter)stz.pop();
            if (p2 instanceof ImagePainter) {
                MutablePoint2D p0 = this.paintImage(f, (ImagePainter)p2, x2, y2, rx / (double)w2, ry / (double)h2, mesg);
                if (stk.isEmpty()) continue;
                if (bef instanceof BesidePainter) {
                    stx.pop();
                    stx.push(x2 + p0.getX() / (double)w2);
                    continue;
                }
                if (!(bef instanceof BelowPainter)) continue;
                sty.pop();
                sty.push(y2 + p0.getY() / (double)h2);
                continue;
            }
            if (p2 instanceof BesidePainter) {
                stk.push(((BesidePainter)p2).getRight());
                stw.push(w2 * 2);
                sth.push(h2);
                stx.push(x2);
                sty.push(y2);
                stz.push(p2);
                stk.push(((BesidePainter)p2).getLeft());
                stw.push(w2 * 2);
                sth.push(h2);
                stx.push(x2);
                sty.push(y2);
                stz.push(p2);
                continue;
            }
            if (!(p2 instanceof BelowPainter)) continue;
            stk.push(((BelowPainter)p2).getBelow());
            stw.push(w2);
            sth.push(h2 * 2);
            stx.push(x2);
            sty.push(y2);
            stz.push(p2);
            stk.push(((BelowPainter)p2).getAbove());
            stw.push(w2);
            sth.push(h2 * 2);
            stx.push(x2);
            sty.push(y2);
            stz.push(p2);
        }
        return Undef.UNDEF;
    }
}

