/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.sos;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.SymbolName;
import net.morilib.lisp.sos.LispClass;
import net.morilib.lisp.sos.LispObject;
import net.morilib.lisp.sos.LispTypeException;
import net.morilib.lisp.sos.SOS;
import net.morilib.lisp.util.ConsIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedefineClass
extends Subr {
    private List<Symbol> glist(Datum lx, LispMessage mesg) {
        ArrayList<Symbol> res = new ArrayList<Symbol>();
        for (Datum d : new ConsIterable(lx, mesg)) {
            if (d instanceof SymbolName) {
                res.add(((SymbolName)((Object)d)).getSymbol());
                continue;
            }
            throw mesg.getError("err.require.symbol", d);
        }
        return res;
    }

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> l0 = LispUtils.consToList(body, mesg);
        ArrayList<LispClass> l1 = new ArrayList<LispClass>();
        LispObject meta = null;
        if (l0.size() < 6 || l0.size() > 7) {
            throw mesg.getError("err.argument", body);
        }
        if (!(l0.get(0) instanceof LispClass)) {
            throw mesg.getError("err.require.class", l0.get(0));
        }
        LispClass r0 = (LispClass)l0.get(0);
        for (Datum d : new ConsIterable(l0.get(1), mesg)) {
            if (d instanceof LispClass) {
                l1.add((LispClass)d);
                continue;
            }
            throw mesg.getError("err.require.class", d);
        }
        List<Symbol> l2 = this.glist(l0.get(2), mesg);
        List<Symbol> l3 = this.glist(l0.get(3), mesg);
        List<Symbol> l4 = this.glist(l0.get(4), mesg);
        Map<Symbol, Datum> vals = LispUtils.assocToMapSymbol(l0.get(5));
        if (vals == null) {
            throw mesg.getError("err.require.assoc");
        }
        if (l0.size() >= 7) {
            Datum z = l0.get(6);
            if (z instanceof LispObject) {
                meta = (LispObject)z;
            } else {
                throw mesg.getError("err.require.class", z);
            }
        }
        try {
            return SOS.getInstance().redefineClass(r0, l1, l2, l3, l4, vals, meta);
        }
        catch (LispTypeException e) {
            String msg = e.getMessage();
            if (msg == null || msg.equals("")) {
                throw mesg.getError("err.inherit.contradict");
            }
            throw mesg.getError(msg);
        }
    }
}

