/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.sound;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.MultiValues;
import net.morilib.lisp.sound.LispAudioFormat;
import net.morilib.lisp.sound.LispDataLine;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.uvector.LispF32Vector;
import net.morilib.util.Endianness2;

public class LispTargetDataLine
extends Datum2
implements LispDataLine {
    private TargetDataLine targetLine;
    private AudioFormat audioFormat;

    private LispTargetDataLine(TargetDataLine target, AudioFormat format) {
        this.targetLine = target;
        this.audioFormat = format;
    }

    public void open() throws LineUnavailableException {
        this.targetLine.open(this.audioFormat);
    }

    public void start() {
        this.targetLine.start();
    }

    public void stop() {
        this.targetLine.stop();
    }

    public void flush() {
        this.targetLine.flush();
    }

    public void close() {
        this.targetLine.close();
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<target-data-line>");
    }

    /* synthetic */ LispTargetDataLine(TargetDataLine targetDataLine, AudioFormat audioFormat, LispTargetDataLine lispTargetDataLine) {
        this(targetDataLine, audioFormat);
    }

    public static class MakeTargetDataLine
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof LispAudioFormat)) {
                throw mesg.getError("err.sound.require.audioformat", c1a);
            }
            try {
                LispAudioFormat f = (LispAudioFormat)c1a;
                DataLine.Info info = new DataLine.Info(TargetDataLine.class, f.audioFormat);
                TargetDataLine t = (TargetDataLine)AudioSystem.getLine(info);
                return new LispTargetDataLine(t, f.audioFormat, null);
            }
            catch (LineUnavailableException e) {
                throw mesg.getError("err.sound.lineunavailable");
            }
        }
    }

    public static class ReadDataLineRelative
    extends BinaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof LispTargetDataLine)) {
                throw mesg.getError("err.sound.require.dataline.target", c1a);
            }
            if (!(c2a instanceof LispSmallInt)) {
                throw mesg.getError("err.require.smallint", c2a);
            }
            int size = c2a.getInt();
            if (size < 0) {
                throw mesg.getError("err.require.int.nonnegative", c2a);
            }
            LispTargetDataLine t = (LispTargetDataLine)c1a;
            AudioFormat af = t.audioFormat;
            int bts = af.getSampleSizeInBits() >> 3;
            byte[] buf = new byte[size * af.getChannels() * bts];
            Datum[] res = new LispF32Vector[af.getChannels()];
            Endianness2 end = af.isBigEndian() ? Endianness2.BIG : Endianness2.LITTLE;
            t.targetLine.read(buf, 0, buf.length);
            int j = 0;
            while (j < af.getChannels()) {
                res[j] = LispF32Vector.malloc(size);
                ++j;
            }
            int i = 0;
            while (i < size) {
                int j2 = 0;
                while (j2 < af.getChannels()) {
                    double f;
                    long ll;
                    if (af.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
                        ll = end.readu(buf, (i * af.getChannels() + j2) * bts, bts);
                        f = (double)ll / (double)(1 << bts * 8);
                    } else {
                        ll = end.read(buf, (i * af.getChannels() + j2) * bts, bts);
                        f = (double)ll / (double)(1 << bts * 8 - 1);
                    }
                    ((LispF32Vector)res[j2]).set(i, f);
                    ++j2;
                }
                ++i;
            }
            return MultiValues.newValues(res);
        }
    }
}

