/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.sql.LispJdbcClosable;
import net.morilib.lisp.sql.LispSQLUtils;
import net.morilib.sql.util.DBMSDependentException;

public class LispJdbcPrepared
extends Datum
implements LispJdbcClosable {
    private PreparedStatement prepared;
    private boolean closed = false;

    public LispJdbcPrepared(Connection connection, String sql) throws SQLException {
        this.prepared = connection.prepareStatement(sql);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() throws SQLException {
        if (!this.closed) {
            this.prepared.close();
            this.prepared = null;
            this.closed = true;
        }
    }

    public void setDatum(int i, Datum d) throws SQLException, DBMSDependentException {
        if (!this.closed) {
            LispSQLUtils.getSQLUtils().setParameter(this.prepared, i, d);
        }
    }

    public ResultSet query() throws SQLException {
        return this.closed ? null : this.prepared.executeQuery();
    }

    public int update() throws SQLException {
        return this.closed ? 0 : this.prepared.executeUpdate();
    }
}

