/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.subr;

import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;

public class Min
extends Subr {
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> lst = LispUtils.consToList(body, mesg);
        if (lst.size() < 1) {
            throw mesg.getError("err.argument", this.symbolName);
        }
        if (!(lst.get(0) instanceof LispReal)) {
            throw mesg.getError("err.require.real", lst.get(0));
        }
        LispReal res = (LispReal)lst.get(0);
        int i = 1;
        while (i < lst.size()) {
            Datum d = lst.get(i);
            if (d instanceof LispReal) {
                LispReal d2 = (LispReal)d;
                if (res.isNaN()) {
                    res = d2;
                } else if (!d2.isNaN()) {
                    if (!res.isExact()) {
                        LispReal d3 = d2.toInexact();
                        res = res.isLessThan(d2) ? res : d3;
                    } else {
                        res = !d2.isExact() ? ((res = res.toInexact()).isLessThan(d2) ? res : d2) : (res.isLessThan(d2) ? res : d2);
                    }
                }
            } else {
                throw mesg.getError("err.require.real", d);
            }
            ++i;
        }
        return res;
    }
}

