/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.subr;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Keyword;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Symbol;
import net.morilib.util.Iterators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SubrUtils {
    private SubrUtils() {
    }

    public static BigInteger ceil(BigInteger n, BigInteger d) {
        BigInteger v = n;
        if (v.compareTo(BigInteger.ZERO) > 0) {
            v = v.add(d);
        }
        return v.divide(d);
    }

    public static BigInteger floor(BigInteger n, BigInteger d) {
        BigInteger v = n;
        if (v.compareTo(BigInteger.ZERO) < 0) {
            v = v.subtract(d);
        }
        return v.divide(d);
    }

    public static Integer toIntExact(BigInteger i) {
        int r = i.intValue();
        if (i.equals(BigInteger.valueOf(r))) {
            return new Integer(r);
        }
        return null;
    }

    public static int getSmallIntegerExact(Datum d, LispMessage mesg) {
        if (d instanceof LispSmallInt) {
            LispSmallInt li = (LispSmallInt)d;
            return li.getExactSmallInt();
        }
        throw mesg.getError("err.require.smallint", d);
    }

    public static char getCharacter(Datum d, LispMessage mesg) {
        if (d instanceof LispCharacter) {
            return ((LispCharacter)d).getCharacter();
        }
        throw mesg.getError("err.require.char", d);
    }

    public static String getString(Datum d, LispMessage mesg) {
        if (d instanceof LispString) {
            return ((LispString)d).getString();
        }
        throw mesg.getError("err.require.string", d);
    }

    public static double getDouble(Datum d, LispMessage mesg) {
        if (d instanceof LispReal) {
            return d.getRealDouble();
        }
        throw mesg.getError("err.require.real", d);
    }

    public static String getSymbolName(Datum d, LispMessage mesg) {
        if (d instanceof Symbol) {
            return ((Symbol)d).getName();
        }
        throw mesg.getError("err.require.symbol", d);
    }

    public static void checkTerminated(ConsIterator itr, Datum body, LispMessage mesg) {
        if (itr.hasNext()) {
            throw mesg.getError("err.argument", body);
        }
        if (!itr.getTerminal().isNil()) {
            throw mesg.getError("err.list", body);
        }
    }

    public static Datum nextIf(Iterator<Datum> itr, LispMessage mesg, String errcd) {
        return Iterators.nextIf(itr, mesg.getError(errcd));
    }

    public static Datum nextIf(Iterator<Datum> itr, LispMessage mesg, String errcd, String ed) {
        return Iterators.nextIf(itr, mesg.getError(errcd, ed));
    }

    public static Datum nextIf(Iterator<Datum> itr, LispMessage mesg, String errcd, Datum ed) {
        return Iterators.nextIf(itr, mesg.getError(errcd, ed));
    }

    public static Datum nextIf(Iterator<Datum> itr, LispMessage mesg, Datum body) {
        return Iterators.nextIf(itr, mesg.getError("err.argument", body));
    }

    public static String nextString(Iterator<Datum> itr, String s, LispMessage mesg) {
        Datum d = Iterators.nextIf(itr, null);
        if (d == null) {
            return s;
        }
        if (d instanceof LispString) {
            return d.getString();
        }
        throw mesg.getError("err.require.string", d);
    }

    public static String nextString(Iterator<Datum> itr, LispMessage mesg, Datum body) {
        Datum d = Iterators.nextIf(itr, null);
        if (d == null) {
            throw mesg.getError("err.argument", body);
        }
        if (d instanceof LispString) {
            return d.getString();
        }
        throw mesg.getError("err.require.string", d);
    }

    public static String nextSymbolName(Iterator<Datum> itr, String s, LispMessage mesg) {
        Datum d = Iterators.nextIf(itr, null);
        if (d == null) {
            return s;
        }
        if (d instanceof Symbol) {
            return ((Symbol)d).getName();
        }
        throw mesg.getError("err.require.symbol", d);
    }

    public static String nextSymbolName(Iterator<Datum> itr, LispMessage mesg, Datum body) {
        Datum d = Iterators.nextIf(itr, null);
        if (d == null) {
            throw mesg.getError("err.argument", body);
        }
        if (d instanceof Symbol) {
            return ((Symbol)d).getName();
        }
        throw mesg.getError("err.require.symbol", d);
    }

    public static int nextSmallInt(Iterator<Datum> itr, int s, LispMessage mesg) {
        Datum d = Iterators.nextIf(itr, null);
        if (d == null) {
            return s;
        }
        if (d instanceof LispSmallInt) {
            return d.getInt();
        }
        throw mesg.getError("err.require.smallint", d);
    }

    public static int nextSmallInt(Iterator<Datum> itr, LispMessage mesg, Datum body) {
        Datum d = Iterators.nextIf(itr, null);
        if (d == null) {
            throw mesg.getError("err.argument", body);
        }
        if (d instanceof LispSmallInt) {
            return d.getInt();
        }
        throw mesg.getError("err.require.smallint", d);
    }

    public static String nextKeywordName(Iterator<Datum> itr, LispMessage mesg, Datum body) {
        Datum d = Iterators.nextIf(itr, null);
        if (d == null) {
            throw mesg.getError("err.argument", body);
        }
        if (d instanceof Keyword) {
            return ((Keyword)d).getName();
        }
        throw mesg.getError("err.require.keyword", d);
    }

    public static Datum cxxr(String xx, Datum d) {
        Datum p = d;
        int i = xx.length() - 1;
        while (i >= 0) {
            switch (xx.charAt(i)) {
                case 'a': {
                    if (p instanceof Cons) {
                        p = ((Cons)p).getCar();
                        break;
                    }
                    return null;
                }
                case 'd': {
                    if (p instanceof Cons) {
                        p = ((Cons)p).getCdr();
                        break;
                    }
                    return null;
                }
                default: {
                    throw new IllegalArgumentException(xx);
                }
            }
            --i;
        }
        return p;
    }

    public static Datum unwrap(Datum d, LispMessage mesg, String m) {
        if (d instanceof Cons) {
            Cons c1 = (Cons)d;
            if (c1.getCdr().isNil()) {
                return c1.getCar();
            }
            throw mesg.getError(m, d);
        }
        throw mesg.getError(m, d);
    }

    public static Map<Keyword, Datum> keywordArgsToMap(Datum d, Datum body, LispMessage mesg) {
        HashMap<Keyword, Datum> res = new HashMap<Keyword, Datum>();
        ConsIterator itr = new ConsIterator(d);
        while (itr.hasNext()) {
            Datum d1 = itr.next();
            if (!(d1 instanceof Keyword)) {
                throw mesg.getError("err.require.keyword", d1);
            }
            if (!itr.hasNext()) {
                throw mesg.getError("err.argument", body);
            }
            res.put((Keyword)d1, itr.next());
        }
        if (!itr.getTerminal().isNil()) {
            throw mesg.getError("err.list", body);
        }
        return res;
    }

    public static void checkType(Datum c1a, Class<?> class1, LispMessage mesg, String string) {
        if (!class1.isInstance(c1a)) {
            throw mesg.getError(string, c1a);
        }
    }
}

