/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.JavaObjective;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.swing.ILispMenu;
import net.morilib.lisp.swing.LispMenuItem;
import net.morilib.lisp.swing.LispSwing;

public class LispMenuBar
extends Datum2
implements ILispMenu,
JavaObjective {
    private JMenuBar menubar;

    static JComponent parseMenu(Datum d, Environment env, LispMessage mesg) {
        if (d instanceof LispMenuItem) {
            return ((LispMenuItem)d).item;
        }
        List<Datum> l = LispUtils.consToList(d, mesg);
        if (l.size() == 2) {
            String t = SubrUtils.getString(l.get(0), mesg);
            if (l.get(1) instanceof Procedure) {
                JMenuItem itm = new JMenuItem(t);
                itm.addActionListener(LispSwing.createActionListener(l.get(1), env, mesg));
                return itm;
            }
            if (l.get(1) instanceof Cons) {
                JMenu men = new JMenu(t);
                ConsIterator itr = new ConsIterator(l.get(1));
                while (itr.hasNext()) {
                    Datum z = itr.next();
                    if (z.equals(Symbol.getSymbol("separator"))) {
                        men.addSeparator();
                        continue;
                    }
                    men.add(LispMenuBar.parseMenu(z, env, mesg));
                }
                if (!itr.getTerminal().isNil()) {
                    throw mesg.getError("err.list", l.get(1));
                }
                return men;
            }
            if (!l.get(1).isTrue()) {
                return new JMenuItem(t);
            }
            throw mesg.getError("err.swing.invalidmenu", d);
        }
        if (l.size() == 4) {
            String t = SubrUtils.getString(l.get(0), mesg);
            JMenuItem m = new JMenuItem(t);
            m.addActionListener(LispSwing.createActionListener(l.get(1), env, mesg));
            m.setAccelerator(LispSwing.toKeyStroke(l.get(2), l.get(3), mesg));
            return m;
        }
        throw mesg.getError("err.swing.invalidmenu", d);
    }

    static JMenuBar parseMenuBar(Datum d, Environment env, LispMessage mesg) {
        JMenuBar mb = new JMenuBar();
        ConsIterator itr = new ConsIterator(d);
        while (itr.hasNext()) {
            mb.add(LispMenuBar.parseMenu(itr.next(), env, mesg));
        }
        if (!itr.getTerminal().isNil()) {
            throw mesg.getError("err.list", d);
        }
        return mb;
    }

    public LispMenuBar(JMenuBar menu) {
        this.menubar = menu;
    }

    public JMenuBar getMenuBar() {
        return this.menubar;
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<menu>");
    }

    public Object toObject() {
        return this.menubar;
    }

    public static class MakeMenu
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof Cons) {
                return new LispMenuBar(LispMenuBar.parseMenuBar(c1a, env, mesg));
            }
            throw mesg.getError("err.require.list", c1a);
        }
    }
}

