/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.awt.Component;
import java.util.List;
import javax.swing.JTextArea;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.swing.GUIElement;
import net.morilib.lisp.swing.HasText;
import net.morilib.lisp.swing.LispComponent;

public class LispTextArea
extends GUIElement
implements LispComponent,
HasText {
    private JTextArea area;

    public LispTextArea(JTextArea a) {
        this.area = a;
    }

    public JTextArea getComponent() {
        return this.area;
    }

    public String getText() {
        return this.area.getText();
    }

    public void setText(String s) {
        this.area.setText(s);
    }

    public Component getAWTComponent() {
        return this.getComponent();
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<text-area>");
    }

    public static class MakeTextArea
    extends Subr {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            JTextArea f;
            List<Datum> l = LispUtils.consToList(body, mesg);
            if (l.size() == 0) {
                f = new JTextArea();
            } else if (l.size() == 2) {
                int row = SubrUtils.getSmallIntegerExact(l.get(0), mesg);
                int col = SubrUtils.getSmallIntegerExact(l.get(1), mesg);
                f = new JTextArea(row, col);
            } else {
                throw mesg.getError("err.argument", body);
            }
            return new LispTextArea(f);
        }
    }
}

