/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.xml;

import java.util.ArrayList;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Symbol;
import net.morilib.util.ArrayListStack;
import net.morilib.util.Stack2;
import net.morilib.util.xml.XMLDeclaration;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

class SXMLHandler
extends DefaultHandler2 {
    private Stack2<ConsListBuilder> builder;
    private boolean trim;
    private boolean comment;
    private XMLDeclaration decl;

    public SXMLHandler(XMLDeclaration decl, boolean trim, boolean comment) {
        this.trim = trim;
        this.comment = comment;
        this.decl = decl;
        this.builder = new ArrayListStack<ConsListBuilder>();
        this.builder.add(new ConsListBuilder());
    }

    private Datum processAttributes(Attributes attrs) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        ConsListBuilder b = new ConsListBuilder();
        ConsListBuilder c = new ConsListBuilder();
        int i = 0;
        while (i < attrs.getLength()) {
            String a = attrs.getQName(i);
            if (a.startsWith("xmlns:") || a.equals("xmlns")) {
                l.add(i);
            } else {
                b.append(LispUtils.list(Symbol.getSymbol(attrs.getQName(i)), new LispString(attrs.getValue(i))));
            }
            ++i;
        }
        if (l.size() > 0) {
            i = 0;
            while (i < l.size()) {
                String z = attrs.getQName((Integer)l.get(i));
                z = z.equals("xmlns") ? "*DEFAULT*" : z.replaceFirst("^xmlns:", "");
                c.append(LispUtils.list(Symbol.getSymbol(z), new LispString(attrs.getValue((Integer)l.get(i)))));
                ++i;
            }
            Datum d = LispUtils.listDot(c.get(), Symbol.getSymbol("*NAMESPACES*"));
            d = LispUtils.list(Symbol.getSymbol("@"), d);
            b.append(d);
        }
        return b.get();
    }

    public void startDocument() throws SAXException {
        this.builder.peek().append(Symbol.getSymbol("*TOP*"));
        if (this.decl != null) {
            this.builder.peek().append(LispUtils.list(Symbol.getSymbol("*PI*"), Symbol.getSymbol("xml"), new LispString(this.decl.toString())));
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String q = qName;
        if (uri != null && !uri.equals("")) {
            q = String.valueOf(uri) + ":" + q;
        }
        this.builder.add(new ConsListBuilder());
        this.builder.peek().append(Symbol.getSymbol(q));
        if (attributes.getLength() > 0) {
            this.builder.peek().append(LispUtils.listDot(this.processAttributes(attributes), Symbol.getSymbol("@")));
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        ConsListBuilder b = this.builder.pop();
        this.builder.peek().append(b.get());
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String s = new String(ch, start, length);
        if (this.trim) {
            s = s.trim();
        }
        if (!s.isEmpty()) {
            this.builder.peek().append(new LispString(s));
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        ConsListBuilder b = new ConsListBuilder();
        b.append(Symbol.getSymbol("*PI*"));
        b.append(Symbol.getSymbol(target));
        b.append(new LispString(data));
        this.builder.peek().append(b.get());
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.comment) {
            String s = new String(ch, start, length);
            this.builder.peek().append(new Cons(Symbol.getSymbol("*COMMENT*"), new Cons(new LispString(s), Nil.NIL)));
        }
    }

    public Datum getResult() {
        return this.builder.peek().get();
    }
}

