/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.math.functions;

import java.io.Serializable;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import net.morilib.lang.algebra.FieldElement;
import net.morilib.math.functions.Polynomial1Coefficients;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedMapPolynomial1Coefficients<C extends FieldElement<C>>
extends Polynomial1Coefficients<C>
implements Serializable {
    private static final long serialVersionUID = 3911167163889106012L;
    private SortedMap<Integer, C> coefficients;

    public SortedMapPolynomial1Coefficients(SortedMap<Integer, C> coefficients) {
        this.coefficients = new TreeMap<Integer, C>(coefficients);
    }

    private SortedMapPolynomial1Coefficients() {
        this.coefficients = new TreeMap<Integer, C>();
    }

    private SortedMapPolynomial1Coefficients(SortedMapPolynomial1Coefficients<C> d) {
        this.coefficients = new TreeMap<Integer, C>(d.coefficients);
    }

    @Override
    public C getCoefficient(int n) {
        return (C)((FieldElement)this.coefficients.get(n));
    }

    @Override
    protected void setCoefficient(int n, C v) {
        if (v.isZero()) {
            this.coefficients.remove(n);
        } else {
            this.coefficients.put(n, v);
        }
    }

    @Override
    protected Iterator<Integer> indexIterator() {
        return this.coefficients.keySet().iterator();
    }

    @Override
    public int deg() {
        return this.coefficients.isEmpty() ? -1 : this.coefficients.lastKey();
    }

    @Override
    protected Polynomial1Coefficients<C> newInstance(int size) {
        return new SortedMapPolynomial1Coefficients<C>();
    }

    @Override
    public Polynomial1Coefficients<C> duplicate() {
        return new SortedMapPolynomial1Coefficients<C>(this);
    }
}

